(ns burningswell.web.ui.text-field
  (:require ["@material/react-text-field" :default TextField :refer [HelperText Input]]
            [react :as React :refer [createContext createElement]]
            [sablono.core :refer [html]]))

(defn helper-text
  [{:keys [aria-hidden class persistent? role text
           show-to-screen-reader? valid? validation?
           validation-message?]}]
  (createElement
   HelperText
   #js {:aria-hidden aria-hidden
        :children text
        :className class
        :isValid valid?
        :isValidationMessage validation-message?
        :persistent persistent?
        :role role
        :showToScreenReader show-to-screen-reader?
        :validation validation?}))

(defn make-input [& [opts]]
  (createElement Input (clj->js opts)))

(defn make-text-field [opts content]
  (createElement TextField (clj->js (assoc opts :children content))))

(defn text-field
  [{:keys [auto-complete label on-change type value persistent?] :as opts}]
  (html
   [:div.text-field
    (make-text-field
     {:helperText
      (when-let [opts (:helper-text opts)]
        (helper-text opts))
      :label label}
     (make-input
      {:autoComplete auto-complete
       :onChange (or on-change (constantly nil))
       :type type
       :value value}))]))

(defn login [{:keys [helper-text] :as opts}]
  (-> {:label "Login"
       :helper-text (merge {:text "Enter your login."} helper-text)}
      (merge opts)
      (text-field)))

(defn password [{:keys [helper-text] :as opts}]
  (-> {:label "Password"
       :helper-text (merge {:text "Choose a password."} helper-text)
       :type "password"}
      (merge opts)
      (text-field)))
