(ns burningswell.worker.system
  (:gen-class)
  (:require [burningswell.db.connection :as db]
            [burningswell.rabbitmq.core :as rabbitmq]
            [burningswell.worker.addresses :as addresses]
            [burningswell.worker.flickr :as flickr]
            [burningswell.worker.import :as import]
            [burningswell.worker.photos :as photos]
            [burningswell.worker.spot-weather :as spot-weather]
            [com.stuartsierra.component :as component]))

(defn new-system [config]
  (let [{:keys [addresses broker import db flickr photos threads]} config
        broker (assoc broker :threads 5)]
    (-> (component/system-map
         :addresses (addresses/new-worker addresses)
         :broker (rabbitmq/rabbitmq broker)
         :db (db/new-db db)
         :flickr (flickr/new-worker flickr)
         :import (import/new-worker import)
         :photos (photos/new-worker photos)
         :spot-weather (spot-weather/new-worker))
        (component/system-using
         {:addresses [:db :broker]
          :flickr [:db :broker]
          :import [:db :broker]
          :photos [:db :broker]
          :spot-weather [:db :broker]}))))
