(ns burningswell.worker.system
  (:require [burningswell.db.connection :as db]
            [burningswell.rabbitmq.client :as rabbitmq]
            [burningswell.worker.addresses :as addresses]
            [burningswell.worker.flickr :as flickr]
            [burningswell.worker.metrics :as metrics]
            [burningswell.worker.photos :as photos]
            [burningswell.worker.spot-weather :as spot-weather]
            [burningswell.worker.topology :as topology]
            [com.stuartsierra.component :as component]))

(defn new-system [config]
  (let [{:keys [addresses broker import db flickr photos spot-weather]} config]
    (component/system-map
     :addresses (addresses/worker addresses)
     :broker (rabbitmq/client broker)
     :db (db/new-db db)
     :flickr (flickr/worker broker flickr)
     ;; :metrics (metrics/console-reporter)
     :photos (photos/worker photos)
     :spot-weather (spot-weather/worker spot-weather)
     :topology (topology/new-topology broker))))
