(ns burningswell.worker.main
  (:gen-class)
  (:require [burningswell.system :as system]
            [burningswell.worker.config :refer [config]]
            [burningswell.worker.system :refer [new-system]]
            [burningswell.worker.weather.datasets :as weather-datasets]
            [burningswell.worker.weather.models :as weather-models]
            [com.stuartsierra.component :as component]
            [environ.core :refer [env]]))

(defmulti main (fn [args] (-> args first keyword)))

(defmethod main :default [args]
  (system/with-system [system (new-system (config env))]
    (system/on-shutdown #(component/stop system))
    (loop []
      (Thread/sleep 10000)
      (recur))))

(defmethod main :weather-datasets [[_ & args]]
  (apply weather-datasets/-main args))

(defmethod main :weather-models [[_ & args]]
  (apply weather-models/-main args))

(defn -main [& args]
  (main args))
