(ns burningswell.worker.spot-weather
  (:require [burningswell.db.spots :as spots]
            [burningswell.db.weather :as weather]
            [burningswell.rabbitmq.client :as rabbitmq]
            [com.stuartsierra.component :as component]
            [kithara.core :as k]
            [kithara.patterns.dead-letter-backoff
             :refer [with-durable-dead-letter-backoff]]))

(defn create-spot-weather
  "Create the weather current forecast for `spot`."
  [db spot]
  ;; (when-let [spot (spots/by-id db (:id spot))]
  ;;   (weather/import-spot-forecasts db {:spots [spot]})
  ;;   ;; TODO: Queue
  ;;   @(weather/refresh-3-hourly-spot-weather db))
  )

(defmulti process-message
  "Handle messages that require geocoding of addresses."
  (fn [message] (-> message :routing-key keyword)))

(defmethod process-message :spots.created
  [{:keys [body env]}]
  (create-spot-weather (:db env) body)
  {:status :ack})

(defn worker
  "Return a new address worker."
  [config]
  (-> process-message
      (k/consumer {:as rabbitmq/read-edn :consumer-name "Spot Weather"})
      (with-durable-dead-letter-backoff)
      (k/with-durable-queue "worker.weather"
        {:exchange "api" :routing-keys ["spots.created"]})
      (k/with-channel {:prefetch-count 1})
      (k/with-connection (rabbitmq/config (:broker config)))
      (k/with-env config)
      (component/using [:db :topology])))
