(ns burningswell.worker.system
  (:require [burningswell.db.connection :as db]
            [burningswell.metrics.core :as metrics]
            [burningswell.metrics.server :as server]
            [burningswell.rabbitmq.client :as rabbitmq]
            [burningswell.worker.addresses :as addresses]
            [burningswell.worker.flickr :as flickr]
            [burningswell.worker.photos :as photos]
            [burningswell.worker.storage :as storage]
            [burningswell.worker.topology :as topology]
            [burningswell.worker.weather.datasets :as weather-datasets]
            [burningswell.worker.weather.datasources :as weather-datasources]
            [burningswell.worker.weather.models :as weather-models]
            [burningswell.worker.weather.spots :as weather-spots]
            [com.stuartsierra.component :as component]))

(defn new-system [config]
  (let [{:keys [addresses broker import db flickr photos spot-weather]} config]
    (-> (component/system-map
         :addresses (addresses/worker addresses)
         :broker (rabbitmq/client broker)
         :db (db/new-db db)
         :flickr (flickr/worker broker flickr)
         :metrics (metrics/metrics)
         :photos (photos/worker photos)
         :server (server/server (select-keys config [:bind-port]))
         :storage (storage/google (-> config :google :storage))
         :topology (topology/topology broker)
         :weather-datasets (weather-datasets/worker {:broker broker})
         :weather-datasources (weather-datasources/worker {:broker broker})
         :weather-models (weather-models/worker {:broker broker})
         :weather-spots (weather-spots/worker {:broker broker}))
        (component/using {:server [:metrics]}))))
