(ns burningswell.worker.topics
  (:require [burningswell.edn :as edn]
            [jackdaw.serdes.avro :as avro]
            [jackdaw.serdes.edn :as jse]
            [jackdaw.serdes.json :as json]
            [clojure.spec.gen.alpha :as gen]))

(defn config
  "Make a topic config."
  ([topic-name]
   (config topic-name (jse/serde edn/read-opts) (jse/serde edn/read-opts)))
  ([topic-name key-serde value-serde]
   {:topic-name topic-name
    :partition-count 1
    :replication-factor 1
    :topic-config {}
    :key-serde key-serde
    :value-serde value-serde}))

(def api-commands-edn
  "The API commands topic in EDN format."
  (config "burningswell.api.commands"))

(def api-events-edn
  "The API events topic in EDN format."
  (config "burningswell.api.events"))

(def api-commands-json
  "The API commands topic in JSON format."
  (config "burningswell.api.commands.json" (json/serde) (json/serde)))

(def api-events-json
  "The API events topic in JSON format."
  (config "burningswell.api.events.json" (json/serde) (json/serde)))
