(ns burningswell.worker.api.events
  (:require [burningswell.worker.pprint :as pprint]
            [jackdaw.streams :as j]))

(defn pprint [& [opts]]
  (pprint/pprint
   {:application
    {"application.id" "pretty-print-events"
     "bootstrap.servers" (:bootstrap.servers opts)
     "cache.max.bytes.buffering" "0"}
    :input "burningswell.api.events"}))

(defn by-name [stream name]
  (j/filter stream (fn [[_ event]] (= (:name event) name))))
