(ns burningswell.worker.main
  (:gen-class)
  (:require [burningswell.worker.config :refer [config]]
            [burningswell.worker.system :as system]
            [environ.core :refer [env]]
            [peripheral.core :refer [with-start]]
            [burningswell.worker.topics :as topics]))

(defn -main [& args]
  (let [config (config env)]
    (topics/create-or-alter-topics! (:kafka config))
    (with-start [system (system/system config)]
      (loop []
        (Thread/sleep 1000)
        (recur)))))
