(ns burningswell.worker.producer
  (:require [burningswell.edn :as edn]
            [jackdaw.client :as client]
            [jackdaw.serdes.edn :as jse]))

(defn config
  "Returns the producer configuration for opts."
  [& [opts]]
  {"bootstrap.servers" (:bootstrap.servers opts)})

(defn- key-serde
  "Returns the key serde from `opts`."
  [{:keys [key-serde]}]
  (or key-serde (jse/serde edn/read-opts)))

(defn- value-serde
  "Returns the value serde from `opts`."
  [{:keys [value-serde]}]
  (or value-serde (jse/serde edn/read-opts)))

(defn producer
  "Returns a new producer configuration for opts."
  [& [opts]]
  (client/producer
   (config opts)
   {:key-serde (key-serde opts)
    :value-serde (value-serde opts)}))

(defn produce! [producer & args]
  (apply client/produce! producer args))

(defn send! [producer & args]
  (apply client/send! producer args))
