(ns burningswell.worker.system
  (:require [burningswell.db.connection :as db]
            [burningswell.services.facebook :as facebook]
            [burningswell.services.flickr :as flickr]
            [burningswell.services.gravatar :as gravatar]
            [burningswell.services.photos :as photos]
            [burningswell.services.storage :as storage]
            [burningswell.services.vision :as vision]
            [burningswell.worker.driver :as driver]
            [burningswell.worker.geocoder :as geocoder]
            [burningswell.worker.json :as json]
            [burningswell.worker.page-views :as page-views]
            [burningswell.worker.producer :as producer]
            [burningswell.worker.spots.addresses :as spot-addresses]
            [burningswell.worker.spots.flickr-photos :as spot-photos]
            [burningswell.worker.users.profile-photos :as profile-photos]
            [burningswell.worker.weather.datasets :as weather-datasets]
            [burningswell.worker.weather.datasources :as weather-datasources]
            [burningswell.worker.weather.models :as weather-models]
            [burningswell.worker.weather.spots :as spot-weather]
            [com.stuartsierra.component :as component]))

(defn system
  "Return a new system."
  [{:keys [db flickr geocoder kafka storage] :as config}]
  (component/system-map
   :db (db/new-db db)
   :driver (driver/driver)
   :facebook (facebook/service)
   :flickr (flickr/client flickr)
   :gravatar (gravatar/service)
   :geocoder (geocoder/service geocoder)
   :json (json/json kafka)
   :page-views (page-views/page-views kafka)
   :photos (photos/service)
   :producer (producer/producer kafka)
   :profile-photos (profile-photos/worker kafka)
   :spot-addresses (spot-addresses/worker kafka)
   :spot-photos (spot-photos/worker kafka)
   :spot-weather (spot-weather/worker kafka)
   :storage (storage/google storage)
   :vision (vision/service)
   :weather-datasets (weather-datasets/worker kafka)
   :weather-datasources (weather-datasources/worker kafka)
   :weather-models (weather-models/worker kafka)))
