(ns burningswell.worker.util
  (:require [geo.core :as geo]
            [geo.postgis :as postgis]))

(defn point->location
  "Convert a geo point to a :lat, :lng map."
  [point]
  {:lat (geo/point-y point)
   :lng (geo/point-x point)})

(defn location->point
  "Convert a :lat, :lng map to a geo point."
  [{:keys [lat lng]}]
  (when (and lat lng)
    (postgis/point 4326 lng lat)))
