(ns burningswell.worker.config
  (:require [burningswell.config.core :as config]))

(defn config
  "Return the config from `env` for a system."
  [env]
  {:db (config/db env)
   :flickr (config/flickr env)
   :geocoder (merge (config/kafka env) (-> env config/google :maps))
   :kafka (config/kafka env)
   :storage (:storage (config/google env))})
