(ns burningswell.worker.serdes
  (:refer-clojure :exclude [long])
  (:require [burningswell.edn :as edn]
            [jackdaw.serdes.edn :as jse]
            [jackdaw.serdes.json :as json])
  (:import org.apache.kafka.common.serialization.Serdes))

(defn edn
  "Returns a new EDN serde."
  [& [opts]]
  (jse/serde (merge edn/read-opts opts)))

(defn json
  "Returns a new JSON serde."
  []
  (json/serde))

(defn long
  "Returns a new long serde."
  []
  (Serdes/Long))

(defn string
  "Returns a new string serde."
  []
  (Serdes/String))
