(ns monads.cstate
  (:require [monads.core :refer :all])
  (:use [monads.util :only [curryfn]]
        [monads.types :only [if-instance]])
  (:import [monads.types Returned]))


;; this type shouldn't be exposed
(deftype SCont [k a s]
    Object
  (toString [this]
    (with-out-str (print [k a s]))))

(defmonad cstate-m
  :return (fn [a] (fn [k s] (SCont. k a s)))
  :bind (fn [m f]
          (fn [k s]
            (SCont. m (fn [a s] (SCont. (f a) k s)) s)))
  :monadstate {:get-state (fn [k s] (SCont. k s s))
               :put-state (fn [s] (fn [k _] (SCont. k s s)))})

(defn run-cstate [m st]
  (loop [m m c (fn [a st] [a st]) st st]
    (let [m ((run-monad cstate-m m) c st)]
      (if-instance SCont m
                   (recur (.k m) (.a m) (.s m))
                   m))))
