(ns {{ns-name}}.routes.home
  (:require [{{ns-name}}.layout :as layout]
            [compojure.core :refer [defroutes context GET POST ]]
            [ring.util.http-response :as response]
            [ring.util.io :refer [piped-input-stream]]
            [ring.util.response :as r]
            [clojure.java.io :as io]
            [{{ns-name}}.db.core :as db]))

(defn make-file-stream
  [file-stream]
  (piped-input-stream
   (fn [output-stream]
     (.writeTo file-stream output-stream))))

(defn home-page [username]
  (layout/hiccup-render-cljs-base username))

(defroutes home-routes
  (GET "/" req (home-page (:username req)))
  (GET "/docs" [] (-> (response/ok (-> "docs/docs.md" io/resource slurp))
                      (response/header "Content-Type" "text/plain; charset=utf-8"))))

(defroutes db-routes
  (context "/db" []
           (GET  "/test" [] {:test "test"})))
