(ns leiningen.new.byu-odh
  (:use [leiningen.new.templates :only [renderer name-to-path sanitize-ns ->files]]))

(def render (renderer "byu-odh"))

(defn byu-odh
  [name]
  (let [data {:name name
              :ns-name (sanitize-ns name)
              :sanitized (name-to-path name)}]
    (->files data ["test/cljs/{{sanitized}}/core_test.cljs" (render "test/cljs/byu_odh/core_test.cljs" data)]
["src/clj/{{sanitized}}/config.clj" (render "src/clj/byu_odh/config.clj" data)]
["test/cljs/{{sanitized}}/doo_runner.cljs" (render "test/cljs/byu_odh/doo_runner.cljs" data)]
["env/dev/clj/{{sanitized}}/env.clj" (render "env/dev/clj/byu_odh/env.clj" data)]
["env/dev/clj/{{sanitized}}/figwheel.clj" (render "env/dev/clj/byu_odh/figwheel.clj" data)]
["src/clj/{{sanitized}}/layout.clj" (render "src/clj/byu_odh/layout.clj" data)]
["env/dev/clj/{{sanitized}}/dev_middleware.clj" (render "env/dev/clj/byu_odh/dev_middleware.clj" data)]
["src/clj/{{sanitized}}/routes/home.clj" (render "src/clj/byu_odh/routes/home.clj" data)]
["src/clj/{{sanitized}}/styles/main.clj" (render "src/clj/byu_odh/styles/main.clj" data)]
["src/clj/{{sanitized}}/db/migratus.clj" (render "src/clj/byu_odh/db/migratus.clj" data)]
["src/clj/{{sanitized}}/middleware.clj" (render "src/clj/byu_odh/middleware.clj" data)]
["test/clj/{{sanitized}}/test/handler.clj" (render "test/clj/byu_odh/test/handler.clj" data)]
["src/clj/{{sanitized}}/handler.clj" (render "src/clj/byu_odh/handler.clj" data)]
["project.clj" (render "project.clj" data)]
["test/clj/{{sanitized}}/test/db/core.clj" (render "test/clj/byu_odh/test/db/core.clj" data)]
["src/clj/{{sanitized}}/db/core.clj" (render "src/clj/byu_odh/db/core.clj" data)]
["src/clj/{{sanitized}}/core.clj" (render "src/clj/byu_odh/core.clj" data)]
["env/dev/clj/user.clj" (render "env/dev/clj/user.clj" data)]
["src/cljc/{{sanitized}}/validation.cljc" (render "src/cljc/byu_odh/validation.cljc")]
["resources/public/css/style.css" (render "resources/public/css/style.css")]
["resources/public/favicon.ico" (render "resources/public/favicon.ico")]
["resources/public/css/screen.css" (render "resources/public/css/screen.css")]
["env/dev/resources/logback.xml" (render "env/dev/resources/logback.xml")]
["resources/migrations/init.sql" (render "resources/migrations/init.sql")]
["env/dev/resources/config.edn" (render "env/dev/resources/config.edn")]
)))