(ns {{ns-name}}.handler
  (:require [compojure.core :refer [routes wrap-routes]]
            [{{ns-name}}.layout :refer [error-page]]
            [{{ns-name}}.routes.home :as routes]
            [compojure.route :as route]
            [{{ns-name}}.env :refer [defaults]]
            [mount.core :as mount]
            [{{ns-name}}.middleware :as middleware]))

(mount/defstate init-app
                :start ((or (:init defaults) identity))
                :stop  ((or (:stop defaults) identity)))

(defn app-routes []
  (routes
    (-> #'routes/home-routes
        (wrap-routes middleware/wrap-csrf)
        (wrap-routes middleware/wrap-formats))
    (-> #'routes/db-routes
        (wrap-routes middleware/wrap-formats) ; TODO these need to be session-protected so institution contacts aren't revealed
        )
    
    (route/not-found
      (:body
        (error-page {:status 404
                     :title "page not found"})))))

(defn app [] (middleware/wrap-base (app-routes)))
