(ns kulu-backend.handler
  (:require [compojure.api.sweet :refer :all]
            [ring.util.http-response :refer :all]
            [schema.core :as s]
            [kulu-backend.models.invoice :as invoice]))

(s/defschema Invoice {:id java.util.UUID
                      (s/optional-key :name) s/Str
                      (s/optional-key :date) java.util.Date
                      (s/optional-key :amount) Double
                      (s/optional-key :currency) s/Str
                      :storage_key s/Str})

(defapi app
  (swagger-ui)
  (swagger-docs
    :title "Kulu API"
    :description "This is Kulu API.")
  (swaggered "Invoices"
             :description "Operations for Invoices"
             (POST* "/invoices" []
                    :return Invoice
                    :body-params [storage_key :- s/Str]
                    :summary "Creates an invoice based on the storage key.
                    Call this after uploading the user's invoice to the data-store.
                    A storage-key is the uploaded object's key in the data-store
                    (currently S3). Later on, the invoice can be filled in with more
                    details (such as name, date, amount etc.)."
                    (created (invoice/create {:temp_storage_key storage_key})))))
