/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLAbstractEntity;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLInfoGetter;
import com.nativelibs4java.opencl.CLPlatform;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.opencl.InfoName;
import com.nativelibs4java.opencl.JavaCL;
import com.nativelibs4java.opencl.library.OpenCLLibrary;
import com.nativelibs4java.util.EnumValues;
import com.ochafik.lang.jnaerator.runtime.NativeSize;
import com.ochafik.lang.jnaerator.runtime.NativeSizeByReference;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.nio.ByteOrder;
import java.util.EnumSet;

public class CLDevice
extends CLAbstractEntity<OpenCLLibrary.cl_device_id> {
    private static CLInfoGetter<OpenCLLibrary.cl_device_id> infos = new CLInfoGetter<OpenCLLibrary.cl_device_id>(){

        @Override
        protected int getInfo(OpenCLLibrary.cl_device_id entity, int infoTypeEnum, NativeSize size, Pointer out, NativeSizeByReference sizeOut) {
            return JavaCL.CL.clGetDeviceInfo(entity, infoTypeEnum, size, out, sizeOut);
        }
    };
    volatile CLPlatform platform;
    ByteOrder kernelsDefaultByteOrder;
    private String[] extensions;

    CLDevice(CLPlatform platform, OpenCLLibrary.cl_device_id device) {
        super(device);
        this.platform = platform;
    }

    public synchronized CLPlatform getPlatform() {
        if (this.platform == null) {
            Pointer pplat = infos.getPointer((OpenCLLibrary.cl_device_id)this.getEntity(), 4145);
            this.platform = new CLPlatform(pplat == null ? null : new OpenCLLibrary.cl_platform_id(pplat));
        }
        return this.platform;
    }

    @Override
    protected void clear() {
    }

    public ByteOrder getByteOrder() {
        return this.isEndianLittle() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    public synchronized ByteOrder getKernelsDefaultByteOrder() {
        if (this.kernelsDefaultByteOrder == null) {
            this.kernelsDefaultByteOrder = ByteOrder.nativeOrder();
        }
        return this.kernelsDefaultByteOrder;
    }

    @InfoName(value="CL_DEVICE_EXECUTION_CAPABILITIES")
    public EnumSet<ExecutionCapability> getExecutionCapabilities() {
        return ExecutionCapability.getEnumSet(infos.getIntOrLong((OpenCLLibrary.cl_device_id)this.getEntity(), 4137));
    }

    @InfoName(value="CL_DEVICE_TYPE")
    public EnumSet<Type> getType() {
        return Type.getEnumSet(infos.getIntOrLong((OpenCLLibrary.cl_device_id)this.getEntity(), 4096));
    }

    @InfoName(value="CL_DEVICE_VENDOR_ID")
    public int getVendorId() {
        return infos.getInt((OpenCLLibrary.cl_device_id)this.getEntity(), 4097);
    }

    @InfoName(value="CL_DEVICE_MAX_COMPUTE_UNITS")
    public int getMaxComputeUnits() {
        return infos.getInt((OpenCLLibrary.cl_device_id)this.getEntity(), 4098);
    }

    @InfoName(value="CL_DEVICE_MAX_WORK_ITEM_DIMENSIONS")
    public int getMaxWorkItemDimensions() {
        return infos.getInt((OpenCLLibrary.cl_device_id)this.getEntity(), 4099);
    }

    @InfoName(value="CL_DEVICE_MAX_WORK_ITEM_SIZES")
    public long[] getMaxWorkItemSizes() {
        long[] sizes = infos.getNativeSizes((OpenCLLibrary.cl_device_id)this.getEntity(), 4101, this.getMaxWorkItemDimensions());
        int n = sizes.length;
        for (int i = 0; i < n; ++i) {
            long size = sizes[i];
            if ((size & 0xFFFFFFFF00000000L) != -3689348818177884160L) continue;
            sizes[i] = size & 0xFFFFFFFFL;
        }
        return sizes;
    }

    @InfoName(value="CL_DEVICE_MAX_WORK_GROUP_SIZE")
    public long getMaxWorkGroupSize() {
        return infos.getIntOrLong((OpenCLLibrary.cl_device_id)this.getEntity(), 4100);
    }

    @InfoName(value="CL_DEVICE_MAX_CLOCK_FREQUENCY")
    public int getMaxClockFrequency() {
        return infos.getInt((OpenCLLibrary.cl_device_id)this.getEntity(), 4108);
    }

    @InfoName(value="CL_DEVICE_ADDRESS_BITS")
    public int getAddressBits() {
        return infos.getInt((OpenCLLibrary.cl_device_id)this.getEntity(), 4109);
    }

    @InfoName(value="CL_DEVICE_MAX_MEM_ALLOC_SIZE")
    public long getMaxMemAllocSize() {
        return infos.getIntOrLong((OpenCLLibrary.cl_device_id)this.getEntity(), 4112);
    }

    @InfoName(value="CL_DEVICE_IMAGE_SUPPORT")
    public boolean hasImageSupport() {
        return infos.getBool((OpenCLLibrary.cl_device_id)this.getEntity(), 4118);
    }

    @InfoName(value="CL_DEVICE_MAX_READ_IMAGE_ARGS")
    public int getMaxReadImageArgs() {
        return infos.getInt((OpenCLLibrary.cl_device_id)this.getEntity(), 4110);
    }

    @InfoName(value="CL_DEVICE_MAX_WRITE_IMAGE_ARGS")
    public int getMaxWriteImageArgs() {
        return infos.getInt((OpenCLLibrary.cl_device_id)this.getEntity(), 4111);
    }

    public String toString() {
        return this.getName();
    }

    public CLQueue createQueue(CLContext context, QueueProperties ... queueProperties) {
        IntByReference pErr = new IntByReference();
        long flags = 0L;
        for (QueueProperties prop : queueProperties) {
            flags |= prop.getValue();
        }
        OpenCLLibrary.cl_command_queue queue = JavaCL.CL.clCreateCommandQueue((OpenCLLibrary.cl_context)context.getEntity(), (OpenCLLibrary.cl_device_id)this.getEntity(), flags, pErr);
        CLException.error(pErr.getValue());
        return new CLQueue(context, queue, this);
    }

    @Deprecated
    public CLQueue createQueue(EnumSet<QueueProperties> queueProperties, CLContext context) {
        IntByReference pErr = new IntByReference();
        OpenCLLibrary.cl_command_queue queue = JavaCL.CL.clCreateCommandQueue((OpenCLLibrary.cl_context)context.getEntity(), (OpenCLLibrary.cl_device_id)this.getEntity(), QueueProperties.getValue(queueProperties), pErr);
        CLException.error(pErr.getValue());
        return new CLQueue(context, queue, this);
    }

    public CLQueue createOutOfOrderQueue(CLContext context) {
        return this.createQueue(EnumSet.of(QueueProperties.OutOfOrderExecModeEnable), context);
    }

    public CLQueue createProfilingQueue(CLContext context) {
        return this.createQueue(EnumSet.of(QueueProperties.ProfilingEnable), context);
    }

    @InfoName(value="CL_DEVICE_IMAGE2D_MAX_WIDTH")
    public long getImage2DMaxWidth() {
        return infos.getIntOrLong((OpenCLLibrary.cl_device_id)this.getEntity(), 4113);
    }

    @InfoName(value="CL_DEVICE_IMAGE2D_MAX_HEIGHT")
    public long getImage2DMaxHeight() {
        return infos.getIntOrLong((OpenCLLibrary.cl_device_id)this.getEntity(), 4114);
    }

    @InfoName(value="CL_DEVICE_IMAGE3D_MAX_WIDTH")
    public long getImage3DMaxWidth() {
        return infos.getIntOrLong((OpenCLLibrary.cl_device_id)this.getEntity(), 4115);
    }

    @InfoName(value="CL_DEVICE_IMAGE3D_MAX_HEIGHT")
    public long getImage3DMaxHeight() {
        return infos.getIntOrLong((OpenCLLibrary.cl_device_id)this.getEntity(), 4116);
    }

    @InfoName(value="CL_DEVICE_IMAGE3D_MAX_DEPTH")
    public long getImage3DMaxDepth() {
        return infos.getIntOrLong((OpenCLLibrary.cl_device_id)this.getEntity(), 4117);
    }

    @InfoName(value="CL_DEVICE_MAX_SAMPLERS")
    public int getMaxSamplers() {
        return infos.getInt((OpenCLLibrary.cl_device_id)this.getEntity(), 4120);
    }

    @InfoName(value="CL_DEVICE_MAX_PARAMETER_SIZE")
    public long getMaxParameterSize() {
        return infos.getIntOrLong((OpenCLLibrary.cl_device_id)this.getEntity(), 4119);
    }

    @InfoName(value="CL_DEVICE_MEM_BASE_ADDR_ALIGN")
    public int getMemBaseAddrAlign() {
        return infos.getInt((OpenCLLibrary.cl_device_id)this.getEntity(), 4121);
    }

    @InfoName(value="CL_DEVICE_MIN_DATA_TYPE_ALIGN_SIZE")
    public int getMinDataTypeAlign() {
        return infos.getInt((OpenCLLibrary.cl_device_id)this.getEntity(), 4122);
    }

    @InfoName(value="CL_DEVICE_SINGLE_FP_CONFIG")
    public EnumSet<SingleFPConfig> getSingleFPConfig() {
        return SingleFPConfig.getEnumSet(infos.getIntOrLong((OpenCLLibrary.cl_device_id)this.getEntity(), 4123));
    }

    @InfoName(value="CL_DEVICE_GLOBAL_MEM_CACHE_TYPE")
    public GlobalMemCacheType getGlobalMemCacheType() {
        return GlobalMemCacheType.getEnum(infos.getInt((OpenCLLibrary.cl_device_id)this.getEntity(), 4124));
    }

    @InfoName(value="CL_DEVICE_GLOBAL_MEM_CACHELINE_SIZE")
    public int getGlobalMemCachelineSize() {
        return infos.getInt((OpenCLLibrary.cl_device_id)this.getEntity(), 4125);
    }

    @InfoName(value="CL_DEVICE_GLOBAL_MEM_CACHE_SIZE")
    public long getGlobalMemCacheSize() {
        return infos.getIntOrLong((OpenCLLibrary.cl_device_id)this.getEntity(), 4126);
    }

    @InfoName(value="CL_DEVICE_GLOBAL_MEM_SIZE")
    public long getGlobalMemSize() {
        return infos.getIntOrLong((OpenCLLibrary.cl_device_id)this.getEntity(), 4127);
    }

    @InfoName(value="CL_DEVICE_MAX_CONSTANT_BUFFER_SIZE")
    public long getMaxConstantBufferSize() {
        return infos.getIntOrLong((OpenCLLibrary.cl_device_id)this.getEntity(), 4128);
    }

    @InfoName(value="CL_DEVICE_MAX_CONSTANT_ARGS")
    public int getMaxConstantArgs() {
        return infos.getInt((OpenCLLibrary.cl_device_id)this.getEntity(), 4129);
    }

    @InfoName(value="CL_DEVICE_LOCAL_MEM_TYPE")
    public LocalMemType getLocalMemType() {
        return LocalMemType.getEnum(infos.getInt((OpenCLLibrary.cl_device_id)this.getEntity(), 4130));
    }

    @InfoName(value="CL_DEVICE_LOCAL_MEM_SIZE")
    public long getLocalMemSize() {
        return infos.getIntOrLong((OpenCLLibrary.cl_device_id)this.getEntity(), 4131);
    }

    @InfoName(value="CL_DEVICE_ERROR_CORRECTION_SUPPORT")
    public boolean hasErrorCorrectionSupport() {
        return infos.getBool((OpenCLLibrary.cl_device_id)this.getEntity(), 4132);
    }

    @InfoName(value="CL_DEVICE_PROFILING_TIMER_RESOLUTION")
    public long getProfilingTimerResolution() {
        return infos.getIntOrLong((OpenCLLibrary.cl_device_id)this.getEntity(), 4133);
    }

    @InfoName(value="CL_DEVICE_ENDIAN_LITTLE")
    public boolean isEndianLittle() {
        return infos.getBool((OpenCLLibrary.cl_device_id)this.getEntity(), 4134);
    }

    @InfoName(value="CL_DEVICE_AVAILABLE")
    public boolean isAvailable() {
        return infos.getBool((OpenCLLibrary.cl_device_id)this.getEntity(), 4135);
    }

    @InfoName(value="CL_DEVICE_COMPILER_AVAILABLE")
    public boolean isCompilerAvailable() {
        return infos.getBool((OpenCLLibrary.cl_device_id)this.getEntity(), 4136);
    }

    @InfoName(value="CL_DEVICE_NAME")
    public String getName() {
        return infos.getString((OpenCLLibrary.cl_device_id)this.getEntity(), 4139);
    }

    @InfoName(value="CL_DEVICE_VENDOR")
    public String getVendor() {
        return infos.getString((OpenCLLibrary.cl_device_id)this.getEntity(), 4140);
    }

    @InfoName(value="CL_DRIVER_VERSION")
    public String getDriverVersion() {
        return infos.getString((OpenCLLibrary.cl_device_id)this.getEntity(), 4141);
    }

    @InfoName(value="CL_DEVICE_PROFILE")
    public String getProfile() {
        return infos.getString((OpenCLLibrary.cl_device_id)this.getEntity(), 4142);
    }

    @InfoName(value="CL_DEVICE_PREFERRED_VECTOR_WIDTH_CHAR")
    public int getPreferredVectorWidthChar() {
        return infos.getInt((OpenCLLibrary.cl_device_id)this.getEntity(), 4102);
    }

    @InfoName(value="CL_DEVICE_PREFERRED_VECTOR_WIDTH_SHORT")
    public int getPreferredVectorWidthShort() {
        return infos.getInt((OpenCLLibrary.cl_device_id)this.getEntity(), 4103);
    }

    @InfoName(value="CL_DEVICE_PREFERRED_VECTOR_WIDTH_INT")
    public int getPreferredVectorWidthInt() {
        return infos.getInt((OpenCLLibrary.cl_device_id)this.getEntity(), 4104);
    }

    @InfoName(value="CL_DEVICE_PREFERRED_VECTOR_WIDTH_LONG")
    public int getPreferredVectorWidthLong() {
        return infos.getInt((OpenCLLibrary.cl_device_id)this.getEntity(), 4105);
    }

    @InfoName(value="CL_DEVICE_PREFERRED_VECTOR_WIDTH_FLOAT")
    public int getPreferredVectorWidthFloat() {
        return infos.getInt((OpenCLLibrary.cl_device_id)this.getEntity(), 4106);
    }

    @InfoName(value="CL_DEVICE_PREFERRED_VECTOR_WIDTH_DOUBLE")
    public int getPreferredVectorWidthDouble() {
        return infos.getInt((OpenCLLibrary.cl_device_id)this.getEntity(), 4107);
    }

    @InfoName(value="CL_DEVICE_VERSION")
    public String getVersion() {
        return infos.getString((OpenCLLibrary.cl_device_id)this.getEntity(), 4143);
    }

    @InfoName(value="CL_DEVICE_EXTENSIONS")
    public String[] getExtensions() {
        if (this.extensions == null) {
            this.extensions = infos.getString((OpenCLLibrary.cl_device_id)this.getEntity(), 4144).split("\\s+");
        }
        return this.extensions;
    }

    boolean hasExtension(String name) {
        name = name.trim();
        for (String x : this.getExtensions()) {
            if (!name.equals(x.trim())) continue;
            return true;
        }
        return false;
    }

    public boolean isDoubleSupported() {
        return this.hasExtension("cl_khr_fp64");
    }

    public boolean isHalfSupported() {
        return this.hasExtension("cl_khr_fp16");
    }

    public boolean isByteAddressableStoreSupported() {
        return this.hasExtension("cl_khr_byte_addressable_store");
    }

    public boolean isGLSharingSupported() {
        return this.hasExtension("cl_khr_gl_sharing") || this.hasExtension("cl_APPLE_gl_sharing");
    }

    public boolean isGlobalInt32BaseAtomicsSupported() {
        return this.hasExtension("cl_khr_global_int32_base_atomics");
    }

    public boolean isGlobalInt32ExtendedAtomicsSupported() {
        return this.hasExtension("cl_khr_global_int32_extended_atomics");
    }

    public boolean isLocalInt32BaseAtomicsSupported() {
        return this.hasExtension("cl_khr_local_int32_base_atomics");
    }

    public boolean isLocalInt32ExtendedAtomicsSupported() {
        return this.hasExtension("cl_khr_local_int32_extended_atomics");
    }

    @InfoName(value="CL_DEVICE_QUEUE_PROPERTIES")
    public EnumSet<QueueProperties> getQueueProperties() {
        return QueueProperties.getEnumSet(infos.getIntOrLong((OpenCLLibrary.cl_device_id)this.getEntity(), 4138));
    }

    public static enum QueueProperties {
        OutOfOrderExecModeEnable,
        ProfilingEnable;


        public long getValue() {
            return EnumValues.getValue(this);
        }

        public static long getValue(EnumSet<QueueProperties> set) {
            return EnumValues.getValue(set);
        }

        public static EnumSet<QueueProperties> getEnumSet(long v) {
            return EnumValues.getEnumSet(v, QueueProperties.class);
        }
    }

    public static enum LocalMemType {
        Local,
        Global;


        public long getValue() {
            return EnumValues.getValue(this);
        }

        public static LocalMemType getEnum(long v) {
            return EnumValues.getEnum(v, LocalMemType.class);
        }
    }

    public static enum GlobalMemCacheType {
        None,
        ReadOnlyCache,
        ReadWriteCache;


        public long getValue() {
            return EnumValues.getValue(this);
        }

        public static GlobalMemCacheType getEnum(long v) {
            return EnumValues.getEnum(v, GlobalMemCacheType.class);
        }
    }

    public static enum SingleFPConfig {
        Denorm,
        InfNaN,
        RoundToNearest,
        RoundToZero,
        RoundToInf,
        FMA;


        public long getValue() {
            return EnumValues.getValue(this);
        }

        public static long getValue(EnumSet<SingleFPConfig> set) {
            return EnumValues.getValue(set);
        }

        public static EnumSet<SingleFPConfig> getEnumSet(long v) {
            return EnumValues.getEnumSet(v, SingleFPConfig.class);
        }
    }

    public static enum Type {
        CPU,
        GPU,
        Accelerator,
        Default;


        public long getValue() {
            return EnumValues.getValue(this);
        }

        public static long getValue(EnumSet<Type> set) {
            return EnumValues.getValue(set);
        }

        public static EnumSet<Type> getEnumSet(long v) {
            return EnumValues.getEnumSet(v, Type.class);
        }
    }

    public static enum ExecutionCapability {
        Kernel,
        NativeKernel;


        public long getValue() {
            return EnumValues.getValue(this);
        }

        public static long getValue(EnumSet<ExecutionCapability> set) {
            return EnumValues.getValue(set);
        }

        public static EnumSet<ExecutionCapability> getEnumSet(long v) {
            return EnumValues.getEnumSet(v, ExecutionCapability.class);
        }
    }
}

