/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLImageFormat;
import com.nativelibs4java.opencl.CLMem;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.opencl.InfoName;
import com.nativelibs4java.opencl.JavaCL;
import com.nativelibs4java.opencl.library.OpenCLLibrary;
import com.nativelibs4java.opencl.library.cl_image_format;
import com.nativelibs4java.util.JNAUtils;
import com.nativelibs4java.util.NIOUtils;
import com.ochafik.lang.jnaerator.runtime.NativeSize;
import com.ochafik.lang.jnaerator.runtime.NativeSizeByReference;
import com.ochafik.util.listenable.Pair;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public abstract class CLImage
extends CLMem {
    CLImageFormat format;

    CLImage(CLContext context, OpenCLLibrary.cl_mem entity, CLImageFormat format) {
        super(context, -1L, entity);
        this.format = format;
    }

    @InfoName(value="CL_IMAGE_FORMAT")
    public CLImageFormat getFormat() {
        if (this.format == null) {
            cl_image_format fmt = new cl_image_format();
            fmt.use(infos.getMemory(this.getEntity(), 4368));
            this.format = new CLImageFormat(fmt);
        }
        return this.format;
    }

    @InfoName(value="CL_IMAGE_ELEMENT_SIZE")
    public long getElementSize() {
        return infos.getIntOrLong(this.getEntity(), 4369);
    }

    protected CLEvent read(CLQueue queue, NativeSize[] origin, NativeSize[] region, long rowPitch, long slicePitch, Buffer out, boolean blocking, CLEvent ... eventsToWaitFor) {
        OpenCLLibrary.cl_event[] eventOut = blocking ? null : CLEvent.new_event_out(eventsToWaitFor);
        OpenCLLibrary.cl_event[] evts = CLEvent.to_cl_event_array(eventsToWaitFor);
        CLException.error(JavaCL.CL.clEnqueueReadImage((OpenCLLibrary.cl_command_queue)queue.getEntity(), (OpenCLLibrary.cl_mem)this.getEntity(), blocking ? 1 : 0, origin, region, JNAUtils.toNS(rowPitch), JNAUtils.toNS(slicePitch), Native.getDirectBufferPointer(out), evts == null ? 0 : evts.length, evts, eventOut));
        return CLEvent.createEvent(queue, eventOut);
    }

    protected CLEvent write(CLQueue queue, NativeSize[] origin, NativeSize[] region, long rowPitch, long slicePitch, Buffer in, boolean blocking, CLEvent ... eventsToWaitFor) {
        boolean indirect;
        boolean bl = indirect = !in.isDirect();
        if (indirect) {
            in = NIOUtils.directCopy(in, this.getContext().getByteOrder());
        }
        OpenCLLibrary.cl_event[] eventOut = blocking ? null : CLEvent.new_event_out(eventsToWaitFor);
        OpenCLLibrary.cl_event[] evts = CLEvent.to_cl_event_array(eventsToWaitFor);
        CLException.error(JavaCL.CL.clEnqueueWriteImage((OpenCLLibrary.cl_command_queue)queue.getEntity(), (OpenCLLibrary.cl_mem)this.getEntity(), blocking ? 1 : 0, origin, region, JNAUtils.toNS(rowPitch), JNAUtils.toNS(slicePitch), Native.getDirectBufferPointer(in), evts == null ? 0 : evts.length, evts, eventOut));
        CLEvent evt = CLEvent.createEvent(queue, eventOut);
        if (indirect && !blocking) {
            final Buffer toHold = in;
            evt.invokeUponCompletion(new Runnable(){

                @Override
                public void run() {
                    toHold.rewind();
                }
            });
        }
        return evt;
    }

    protected Pair<ByteBuffer, CLEvent> map(CLQueue queue, CLMem.MapFlags flags, NativeSize[] offset3, NativeSize[] length3, Long imageRowPitch, Long imageSlicePitch, boolean blocking, CLEvent ... eventsToWaitFor) {
        OpenCLLibrary.cl_event[] eventOut = blocking ? null : CLEvent.new_event_out(eventsToWaitFor);
        IntBuffer pErr = NIOUtils.directInts(1, ByteOrder.nativeOrder());
        OpenCLLibrary.cl_event[] evts = CLEvent.to_cl_event_array(eventsToWaitFor);
        Pointer p = JavaCL.CL.clEnqueueMapImage((OpenCLLibrary.cl_command_queue)queue.getEntity(), (OpenCLLibrary.cl_mem)this.getEntity(), blocking ? 1 : 0, flags.getValue(), offset3, length3, imageRowPitch == null ? null : new NativeSizeByReference(JNAUtils.toNS((long)imageRowPitch)), imageSlicePitch == null ? null : new NativeSizeByReference(JNAUtils.toNS((long)imageSlicePitch)), evts == null ? 0 : evts.length, evts, eventOut, pErr);
        CLException.error(pErr.get());
        return new Pair<ByteBuffer, CLEvent>(p.getByteBuffer(0L, this.getByteCount()), CLEvent.createEvent(queue, eventOut));
    }

    public CLEvent unmap(CLQueue queue, ByteBuffer buffer, CLEvent ... eventsToWaitFor) {
        OpenCLLibrary.cl_event[] eventOut = CLEvent.new_event_out(eventsToWaitFor);
        OpenCLLibrary.cl_event[] evts = CLEvent.to_cl_event_array(eventsToWaitFor);
        CLException.error(JavaCL.CL.clEnqueueUnmapMemObject((OpenCLLibrary.cl_command_queue)queue.getEntity(), (OpenCLLibrary.cl_mem)this.getEntity(), Native.getDirectBufferPointer(buffer), evts == null ? 0 : evts.length, evts, eventOut));
        return CLEvent.createEvent(queue, eventOut);
    }
}

