/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.library.cl_image_format;
import com.nativelibs4java.util.EnumValues;

public class CLImageFormat {
    private final ChannelOrder channelOrder;
    private final ChannelDataType channelDataType;

    CLImageFormat(cl_image_format fmt) {
        this(ChannelOrder.getEnum(fmt.image_channel_order), ChannelDataType.getEnum(fmt.image_channel_data_type));
    }

    cl_image_format to_cl_image_format() {
        return new cl_image_format((int)this.channelOrder.getValue(), (int)this.channelDataType.getValue());
    }

    public CLImageFormat(ChannelOrder channelOrder, ChannelDataType channelDataType) {
        this.channelDataType = channelDataType;
        this.channelOrder = channelOrder;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CLImageFormat)) {
            return false;
        }
        CLImageFormat f = (CLImageFormat)obj;
        if (this.channelOrder == null ? f.channelOrder != null : !this.channelOrder.equals((Object)f.channelOrder)) {
            return false;
        }
        if (this.channelDataType == null) {
            return f.channelDataType == null;
        }
        return this.channelDataType.equals((Object)f.channelDataType);
    }

    public int hashCode() {
        int h = super.hashCode();
        if (this.channelOrder != null) {
            h ^= this.channelOrder.hashCode();
        }
        if (this.channelDataType != null) {
            h ^= this.channelDataType.hashCode();
        }
        return h;
    }

    public boolean isIntBased() {
        if (this.channelDataType == null || this.channelOrder == null) {
            return false;
        }
        switch (this.getChannelOrder()) {
            case ARGB: 
            case BGRA: 
            case RGBA: {
                switch (this.getChannelDataType()) {
                    case SNormInt8: 
                    case SignedInt8: 
                    case UNormInt8: 
                    case UnsignedInt8: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public final ChannelOrder getChannelOrder() {
        return this.channelOrder;
    }

    public final ChannelDataType getChannelDataType() {
        return this.channelDataType;
    }

    public String toString() {
        return "(" + (Object)((Object)this.channelOrder) + ", " + (Object)((Object)this.channelDataType) + ")";
    }

    public static enum ChannelDataType {
        SNormInt8(8),
        SNormInt16(16),
        UNormInt8(8),
        UNormInt16(16),
        UNormShort565(16),
        UNormShort555(15),
        UNormInt101010(30),
        SignedInt8(8),
        SignedInt16(16),
        SignedInt32(32),
        UnsignedInt8(8),
        UnsignedInt16(16),
        UnsignedInt32(32),
        HalfFloat(16),
        Float(32);

        public final int SIZE;

        private ChannelDataType(int bits) {
            this.SIZE = bits;
        }

        public long getValue() {
            return EnumValues.getValue(this);
        }

        public static ChannelDataType getEnum(long v) {
            return EnumValues.getEnum(v, ChannelDataType.class);
        }
    }

    public static enum ChannelOrder {
        R,
        A,
        INTENSITY,
        LUMINANCE,
        RG,
        RA,
        RGB,
        RGBA,
        ARGB,
        BGRA;


        public long getValue() {
            return EnumValues.getValue(this);
        }

        public static ChannelOrder getEnum(long v) {
            return EnumValues.getEnum(v, ChannelOrder.class);
        }
    }
}

