/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLAbstractEntity;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLDevice;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLInfoGetter;
import com.nativelibs4java.opencl.InfoName;
import com.nativelibs4java.opencl.JavaCL;
import com.nativelibs4java.opencl.library.OpenCLLibrary;
import com.nativelibs4java.opencl.library.OpenGLContextUtils;
import com.nativelibs4java.util.EnumValues;
import com.nativelibs4java.util.JNAUtils;
import com.ochafik.lang.jnaerator.runtime.NativeSize;
import com.ochafik.lang.jnaerator.runtime.NativeSizeByReference;
import com.sun.jna.Memory;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class CLPlatform
extends CLAbstractEntity<OpenCLLibrary.cl_platform_id> {
    private static CLInfoGetter<OpenCLLibrary.cl_platform_id> infos = new CLInfoGetter<OpenCLLibrary.cl_platform_id>(){

        @Override
        protected int getInfo(OpenCLLibrary.cl_platform_id entity, int infoTypeEnum, NativeSize size, Pointer out, NativeSizeByReference sizeOut) {
            return JavaCL.CL.clGetPlatformInfo(entity, infoTypeEnum, size, out, sizeOut);
        }
    };
    private String[] extensions;

    CLPlatform(OpenCLLibrary.cl_platform_id platform) {
        super(platform, true);
    }

    public String toString() {
        return this.getName() + " {vendor: " + this.getVendor() + ", version: " + this.getVersion() + ", profile: " + this.getProfile() + ", extensions: " + Arrays.toString(this.getExtensions()) + "}";
    }

    @Override
    protected void clear() {
    }

    public CLDevice[] listAllDevices(boolean onlyAvailable) {
        return this.listDevices(EnumSet.allOf(CLDevice.Type.class), onlyAvailable);
    }

    public CLDevice[] listGPUDevices(boolean onlyAvailable) {
        try {
            return this.listDevices(EnumSet.of(CLDevice.Type.GPU), onlyAvailable);
        }
        catch (CLException ex) {
            if (ex.getCode() == -1) {
                return new CLDevice[0];
            }
            throw new RuntimeException("Unexpected OpenCL error", ex);
        }
    }

    public CLDevice[] listCPUDevices(boolean onlyAvailable) {
        try {
            return this.listDevices(EnumSet.of(CLDevice.Type.CPU), onlyAvailable);
        }
        catch (CLException ex) {
            if (ex.getCode() == -1) {
                return new CLDevice[0];
            }
            throw new RuntimeException("Unexpected OpenCL error", ex);
        }
    }

    private CLDevice[] getDevices(OpenCLLibrary.cl_device_id[] ids, boolean onlyAvailable) {
        CLDevice[] devices;
        int nDevs = ids.length;
        if (onlyAvailable) {
            ArrayList<CLDevice> list = new ArrayList<CLDevice>(nDevs);
            for (int i = 0; i < nDevs; ++i) {
                CLDevice device = new CLDevice(this, ids[i]);
                if (!device.isAvailable()) continue;
                list.add(device);
            }
            devices = list.toArray(new CLDevice[list.size()]);
        } else {
            devices = new CLDevice[nDevs];
            for (int i = 0; i < nDevs; ++i) {
                devices[i] = new CLDevice(this, ids[i]);
            }
        }
        return devices;
    }

    static long[] getContextProps(Map<ContextProperties, Number> contextProperties) {
        if (contextProperties == null) {
            return null;
        }
        long[] properties = new long[contextProperties.size() * 2 + 1];
        int iProp = 0;
        for (Map.Entry<ContextProperties, Number> e : contextProperties.entrySet()) {
            properties[iProp++] = e.getKey().getValue();
            properties[iProp++] = e.getValue().longValue();
        }
        properties[iProp] = 0L;
        return properties;
    }

    static CLDevice getBestDevice(DeviceEvaluationStrategy eval, Iterable<CLDevice> devices) {
        CLDevice bestDevice = null;
        for (CLDevice device : devices) {
            if (bestDevice == null) {
                bestDevice = device;
                continue;
            }
            switch (eval) {
                case BiggestMaxComputeUnitsWithNativeEndianness: {
                    if (bestDevice.getKernelsDefaultByteOrder() != ByteOrder.nativeOrder() && device.getKernelsDefaultByteOrder() == ByteOrder.nativeOrder()) {
                        bestDevice = device;
                        break;
                    }
                }
                case BiggestMaxComputeUnits: {
                    if (bestDevice.getMaxComputeUnits() >= device.getMaxComputeUnits()) break;
                    bestDevice = device;
                }
            }
        }
        return bestDevice;
    }

    public CLDevice getBestDevice() {
        return CLPlatform.getBestDevice(DeviceEvaluationStrategy.BiggestMaxComputeUnits, Arrays.asList(this.listGPUDevices(true)));
    }

    public CLContext createContextFromCurrentGL() {
        return this.createGLCompatibleContext(this.listAllDevices(true));
    }

    static Map<ContextProperties, Number> getGLContextProperties() {
        LinkedHashMap<ContextProperties, Number> out = new LinkedHashMap<ContextProperties, Number>();
        if (Platform.isMac()) {
            NativeSize context = OpenGLContextUtils.INSTANCE.CGLGetCurrentContext();
            NativeSize shareGroup = OpenGLContextUtils.INSTANCE.CGLGetShareGroup(context);
            out.put(ContextProperties.GLContext, context.longValue());
            out.put(ContextProperties.CGLShareGroup, shareGroup.longValue());
        } else if (Platform.isWindows()) {
            NativeSize context = OpenGLContextUtils.INSTANCE.wglGetCurrentContext();
            NativeSize dc = OpenGLContextUtils.INSTANCE.wglGetCurrentDC();
            out.put(ContextProperties.GLContext, context.longValue());
            out.put(ContextProperties.WGLHDC, dc.longValue());
        } else if (Platform.isX11()) {
            NativeSize context = OpenGLContextUtils.INSTANCE.glXGetCurrentContext();
            NativeSize dc = OpenGLContextUtils.INSTANCE.glXGetCurrentDisplay();
            out.put(ContextProperties.GLContext, context.longValue());
            out.put(ContextProperties.GLXDisplay, dc.longValue());
        } else {
            throw new UnsupportedOperationException("Current GL context retrieval not implemented on this platform !");
        }
        return out;
    }

    @Deprecated
    public CLContext createGLCompatibleContext(CLDevice ... devices) {
        for (CLDevice device : devices) {
            if (device.isGLSharingSupported()) continue;
            throw new UnsupportedOperationException("Device " + device + " does not support CL/GL sharing.");
        }
        return this.createContext(CLPlatform.getGLContextProperties(), devices);
    }

    public CLContext createContext(Map<ContextProperties, Number> contextProperties, CLDevice ... devices) {
        int nDevs = devices.length;
        if (nDevs == 0) {
            throw new IllegalArgumentException("Cannot create a context with no associated device !");
        }
        OpenCLLibrary.cl_device_id[] ids = new OpenCLLibrary.cl_device_id[nDevs];
        for (int i = 0; i < nDevs; ++i) {
            ids[i] = (OpenCLLibrary.cl_device_id)devices[i].getEntity();
        }
        IntByReference errRef = new IntByReference();
        long[] props = CLPlatform.getContextProps(contextProperties);
        Memory propsMem = JNAUtils.toNSArray(props);
        NativeSizeByReference propsRef = new NativeSizeByReference();
        propsRef.setPointer(propsMem);
        OpenCLLibrary.cl_context context = JavaCL.CL.clCreateContext(propsRef, ids.length, ids, null, null, errRef);
        CLException.error(errRef.getValue());
        return new CLContext(this, ids, context);
    }

    public CLDevice[] listDevices(EnumSet<CLDevice.Type> types, boolean onlyAvailable) {
        int flags = (int)CLDevice.Type.getValue(types);
        IntByReference pCount = new IntByReference();
        CLException.error(JavaCL.CL.clGetDeviceIDs((OpenCLLibrary.cl_platform_id)this.getEntity(), (long)flags, 0, (PointerByReference)null, pCount));
        int nDevs = pCount.getValue();
        if (nDevs == 0) {
            return new CLDevice[0];
        }
        OpenCLLibrary.cl_device_id[] ids = new OpenCLLibrary.cl_device_id[nDevs];
        CLException.error(JavaCL.CL.clGetDeviceIDs((OpenCLLibrary.cl_platform_id)this.getEntity(), (long)flags, nDevs, ids, pCount));
        return this.getDevices(ids, onlyAvailable);
    }

    @InfoName(value="CL_PLATFORM_PROFILE")
    public String getProfile() {
        return infos.getString((OpenCLLibrary.cl_platform_id)this.getEntity(), 2304);
    }

    @InfoName(value="CL_PLATFORM_VERSION")
    public String getVersion() {
        return infos.getString((OpenCLLibrary.cl_platform_id)this.getEntity(), 2305);
    }

    @InfoName(value="CL_PLATFORM_NAME")
    public String getName() {
        return infos.getString((OpenCLLibrary.cl_platform_id)this.getEntity(), 2306);
    }

    @InfoName(value="CL_PLATFORM_VENDOR")
    public String getVendor() {
        return infos.getString((OpenCLLibrary.cl_platform_id)this.getEntity(), 2307);
    }

    @InfoName(value="CL_PLATFORM_EXTENSIONS")
    public String[] getExtensions() {
        if (this.extensions == null) {
            this.extensions = infos.getString((OpenCLLibrary.cl_platform_id)this.getEntity(), 2308).split("\\s+");
        }
        return this.extensions;
    }

    boolean hasExtension(String name) {
        name = name.trim();
        for (String x : this.getExtensions()) {
            if (!name.equals(x.trim())) continue;
            return true;
        }
        return false;
    }

    @InfoName(value="cl_nv_device_attribute_query")
    public boolean isNVDeviceAttributeQuerySupported() {
        return this.hasExtension("cl_nv_device_attribute_query");
    }

    @InfoName(value="cl_nv_compiler_options")
    public boolean isNVCompilerOptionsSupported() {
        return this.hasExtension("cl_nv_compiler_options");
    }

    @InfoName(value="cl_khr_byte_addressable_store")
    public boolean isByteAddressableStoreSupported() {
        return this.hasExtension("cl_khr_byte_addressable_store");
    }

    @InfoName(value="cl_khr_gl_sharing")
    public boolean isGLSharingSupported() {
        return this.hasExtension("cl_khr_gl_sharing") || this.hasExtension("cl_APPLE_gl_sharing");
    }

    public static enum ContextProperties {
        GLContext,
        EGLDisplay,
        GLXDisplay,
        WGLHDC,
        CGLShareGroup;


        public long getValue() {
            return EnumValues.getValue(this);
        }

        public static long getValue(EnumSet<ContextProperties> set) {
            return EnumValues.getValue(set);
        }

        public static EnumSet<ContextProperties> getEnumSet(long v) {
            return EnumValues.getEnumSet(v, ContextProperties.class);
        }
    }

    public static enum DeviceEvaluationStrategy {
        BiggestMaxComputeUnits,
        BiggestMaxComputeUnitsWithNativeEndianness;

    }
}

