/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLAbstractEntity;
import com.nativelibs4java.opencl.CLBuildException;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLDevice;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLInfoGetter;
import com.nativelibs4java.opencl.CLKernel;
import com.nativelibs4java.opencl.JavaCL;
import com.nativelibs4java.opencl.library.OpenCLLibrary;
import com.nativelibs4java.util.JNAUtils;
import com.nativelibs4java.util.NIOUtils;
import com.ochafik.lang.jnaerator.runtime.NativeSize;
import com.ochafik.lang.jnaerator.runtime.NativeSizeByReference;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CLProgram
extends CLAbstractEntity<OpenCLLibrary.cl_program> {
    protected final CLContext context;
    private static CLInfoGetter<OpenCLLibrary.cl_program> infos = new CLInfoGetter<OpenCLLibrary.cl_program>(){

        @Override
        protected int getInfo(OpenCLLibrary.cl_program entity, int infoTypeEnum, NativeSize size, Pointer out, NativeSizeByReference sizeOut) {
            return JavaCL.CL.clGetProgramInfo(entity, infoTypeEnum, size, out, sizeOut);
        }
    };
    CLDevice[] devices;
    List<String> sources = new ArrayList<String>();
    Map<CLDevice, OpenCLLibrary.cl_program> programByDevice = new HashMap<CLDevice, OpenCLLibrary.cl_program>();
    public static boolean passMacrosAsSources = true;
    Map<String, Object> macros;
    boolean built;

    CLProgram(CLContext context, CLDevice ... devices) {
        super(null, true);
        this.context = context;
        this.devices = devices == null || devices.length == 0 ? context.getDevices() : devices;
    }

    public CLDevice[] getDevices() {
        return (CLDevice[])this.devices.clone();
    }

    public synchronized void allocate() {
        if (this.entity != null) {
            throw new IllegalThreadStateException("Program was already allocated !");
        }
        if (passMacrosAsSources && this.macros != null && !this.macros.isEmpty()) {
            StringBuilder b = new StringBuilder();
            for (Map.Entry<String, Object> m : this.macros.entrySet()) {
                b.append("#define " + m.getKey() + " " + m.getValue() + "\n");
            }
            this.sources.add(0, b.toString());
        }
        String[] sources = this.sources.toArray(new String[this.sources.size()]);
        NativeSize[] lengths = new NativeSize[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            lengths[i] = JNAUtils.toNS(sources[i].length());
        }
        IntBuffer errBuff = NIOUtils.directInts(1, ByteOrder.nativeOrder());
        OpenCLLibrary.cl_program program = JavaCL.CL.clCreateProgramWithSource((OpenCLLibrary.cl_context)this.context.getEntity(), sources.length, sources, lengths, errBuff);
        CLException.error(errBuff.get(0));
        this.entity = program;
    }

    @Override
    protected synchronized OpenCLLibrary.cl_program getEntity() {
        if (this.entity == null) {
            this.allocate();
        }
        return (OpenCLLibrary.cl_program)this.entity;
    }

    public synchronized void addSource(String src) {
        if (this.entity != null) {
            throw new IllegalThreadStateException("Program was already allocated : cannot add sources anymore.");
        }
        this.sources.add(src);
    }

    public String getSource() {
        return infos.getString(this.getEntity(), 4452);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<CLDevice, byte[]> getBinaries() throws CLBuildException {
        CLProgram cLProgram = this;
        synchronized (cLProgram) {
            if (!this.built) {
                this.build();
            }
        }
        Memory s = infos.getMemory(this.getEntity(), 4453);
        int n = (int)s.getSize() / Native.SIZE_T_SIZE;
        NativeSize[] sizes = JNAUtils.readNSArray(s, n);
        Memory[] binMems = new Memory[n];
        Memory ptrs = new Memory(n * Native.POINTER_SIZE);
        for (int i = 0; i < n; ++i) {
            binMems[i] = new Memory(sizes[i].intValue());
            ptrs.setPointer(i * Native.POINTER_SIZE, binMems[i]);
        }
        CLException.error(infos.getInfo(this.getEntity(), 4454, JNAUtils.toNS(ptrs.getSize()), ptrs, null));
        HashMap<CLDevice, byte[]> ret = new HashMap<CLDevice, byte[]>(this.devices.length);
        for (int i = 0; i < n; ++i) {
            CLDevice device = this.devices[i];
            Memory bytes = binMems[i];
            ret.put(device, bytes.getByteArray(0L, sizes[i].intValue()));
        }
        return ret;
    }

    public CLContext getContext() {
        return this.context;
    }

    public CLProgram defineMacro(String name, Object value) {
        this.createMacros();
        this.macros.put(name, value);
        return this;
    }

    public CLProgram undefineMacro(String name) {
        if (this.macros != null) {
            this.macros.remove(name);
        }
        return this;
    }

    private void createMacros() {
        if (this.macros == null) {
            this.macros = new LinkedHashMap<String, Object>();
        }
    }

    public void defineMacros(Map<String, Object> macros) {
        this.createMacros();
        this.macros.putAll(macros);
    }

    protected String getOptionsString() {
        if (passMacrosAsSources) {
            return null;
        }
        if (this.macros == null || this.macros.isEmpty()) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        for (Map.Entry<String, Object> m : this.macros.entrySet()) {
            b.append("-D" + m.getKey() + "=" + m.getValue() + " ");
        }
        return b.toString();
    }

    public synchronized CLProgram build() throws CLBuildException {
        int err;
        if (this.built) {
            throw new IllegalThreadStateException("Program was already built !");
        }
        if (this.entity == null) {
            this.allocate();
        }
        int nDevices = this.devices.length;
        OpenCLLibrary.cl_device_id[] deviceIds = null;
        if (nDevices != 0) {
            deviceIds = new OpenCLLibrary.cl_device_id[nDevices];
            for (int i = 0; i < nDevices; ++i) {
                deviceIds[i] = (OpenCLLibrary.cl_device_id)this.devices[i].getEntity();
            }
        }
        if ((err = JavaCL.CL.clBuildProgram(this.getEntity(), nDevices, deviceIds, this.getOptionsString(), null, null)) != 0) {
            NativeSizeByReference len = new NativeSizeByReference();
            int bufLen = 65536;
            Memory buffer = new Memory(bufLen);
            HashSet<String> errs = new HashSet<String>();
            if (deviceIds == null) {
                CLException.error(JavaCL.CL.clGetProgramBuildInfo(this.getEntity(), null, 4483, JNAUtils.toNS(bufLen), buffer, len));
                String s = buffer.getString(0L);
                errs.add(s);
            } else {
                for (OpenCLLibrary.cl_device_id device : deviceIds) {
                    CLException.error(JavaCL.CL.clGetProgramBuildInfo(this.getEntity(), device, 4483, JNAUtils.toNS(bufLen), buffer, len));
                    String s = buffer.getString(0L);
                    errs.add(s);
                }
            }
            throw new CLBuildException(this, "Compilation failure ! (code = " + err + ")", errs);
        }
        this.built = true;
        return this;
    }

    @Override
    protected void clear() {
        CLException.error(JavaCL.CL.clReleaseProgram(this.getEntity()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CLKernel[] createKernels() throws CLBuildException {
        CLProgram cLProgram = this;
        synchronized (cLProgram) {
            if (!this.built) {
                this.build();
            }
        }
        IntByReference pCount = new IntByReference();
        CLException.error(JavaCL.CL.clCreateKernelsInProgram(this.getEntity(), 0, (OpenCLLibrary.cl_kernel[])null, pCount));
        int count = pCount.getValue();
        OpenCLLibrary.cl_kernel[] kerns = new OpenCLLibrary.cl_kernel[count];
        CLException.error(JavaCL.CL.clCreateKernelsInProgram(this.getEntity(), count, kerns, pCount));
        CLKernel[] kernels = new CLKernel[count];
        for (int i = 0; i < count; ++i) {
            kernels[i] = new CLKernel(this, null, kerns[i]);
        }
        return kernels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CLKernel createKernel(String name, Object ... args) throws CLBuildException {
        CLProgram cLProgram = this;
        synchronized (cLProgram) {
            if (!this.built) {
                this.build();
            }
        }
        IntBuffer errBuff = NIOUtils.directInts(1, ByteOrder.nativeOrder());
        OpenCLLibrary.cl_kernel kernel = JavaCL.CL.clCreateKernel(this.getEntity(), name, errBuff);
        CLException.error(errBuff.get(0));
        CLKernel kn = new CLKernel(this, name, kernel);
        kn.setArgs(args);
        return kn;
    }
}

