/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.runtime.jna;

import com.nativelibs4java.runtime.jna.StructIO;
import com.sun.jna.FromNativeContext;
import com.sun.jna.Memory;
import com.sun.jna.NativeMapped;
import com.sun.jna.Pointer;

public abstract class Struct<S extends Struct<S>>
implements NativeMapped {
    protected final StructIO<S> io;
    protected volatile Pointer pointer;
    Object[] refreshableFields;

    protected Struct() {
        this.io = StructIO.getInstance(this.getClass());
        this.io.build();
        this.refreshableFields = this.io.createRefreshableFieldsArray();
    }

    protected Struct(StructIO<S> io) {
        this.io = io;
        io.build();
        this.refreshableFields = io.createRefreshableFieldsArray();
    }

    public int size() {
        return this.io.getStructSize();
    }

    public S clone() {
        try {
            Struct clone = (Struct)this.getClass().newInstance();
            int sz = this.io.getStructSize();
            clone.getPointer().getByteBuffer(0L, sz).put(this.getPointer().getByteBuffer(0L, sz));
            return (S)clone;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to clone struct of type " + this.getClass().getName(), ex);
        }
    }

    public synchronized Pointer getPointer() {
        if (this.pointer == null) {
            this.pointer = new Memory(this.io.getStructSize());
        }
        return this.pointer;
    }

    public synchronized S setPointer(Pointer pointer) {
        if (pointer == null || pointer.equals(Pointer.NULL)) {
            throw new NullPointerException("Cannot set null pointer as struct address !");
        }
        this.pointer = pointer;
        return (S)this;
    }

    public void write() {
        this.io.write(this);
    }

    public void read() {
        this.io.read(this);
    }

    @Override
    public Object fromNative(Object o, FromNativeContext fnc) {
        this.read();
        this.setPointer((Pointer)o);
        return this;
    }

    @Override
    public Object toNative() {
        this.write();
        return this.getPointer();
    }

    @Override
    public Class nativeType() {
        return Pointer.class;
    }
}

