/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.runtime.jna;

import com.nativelibs4java.runtime.ann.jna.Alignment;
import com.nativelibs4java.runtime.ann.jna.Bits;
import com.nativelibs4java.runtime.ann.jna.ByValue;
import com.nativelibs4java.runtime.ann.jna.Length;
import com.nativelibs4java.runtime.ann.jna.Wide;
import com.nativelibs4java.runtime.jna.BitFields;
import com.nativelibs4java.runtime.jna.Struct;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StructIO<S extends Struct<S>> {
    static Map<Class<?>, StructIO<?>> structIOs = new HashMap();
    protected final Class<S> structClass;
    protected volatile FieldIO[] fields;
    private int structSize = -1;
    private int structAlignment = -1;
    protected Field[] javaFields;
    protected Method[] javaIOGetters;
    protected Method[] javaIOSetters;

    public static synchronized <E extends Struct<E>> StructIO<E> getInstance(Class<E> structClass) {
        StructIO<Object> io = structIOs.get(structClass);
        if (io == null) {
            io = new StructIO<E>(structClass);
            StructIO.registerStructIO(structClass, io);
        }
        return io;
    }

    public static synchronized <E extends Struct<E>> StructIO<E> registerStructIO(Class<E> structClass, StructIO<E> io) {
        structIOs.put(structClass, io);
        return io;
    }

    public StructIO(Class<S> structClass) {
        this.structClass = structClass;
    }

    public Class<S> getStructClass() {
        return this.structClass;
    }

    protected int alignSize(int size, int alignment) {
        int r;
        if (alignment != 1 && (r = size % alignment) != 0) {
            size += alignment - r;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build() {
        if (this.fields == null) {
            StructIO structIO = this;
            synchronized (structIO) {
                if (this.fields == null) {
                    this.fields = this.computeStructLayout();
                }
            }
        }
    }

    Object[] createRefreshableFieldsArray() {
        return new Object[this.fields.length];
    }

    public int getStructSize() {
        this.build();
        return this.structSize;
    }

    public int getStructAlignment() {
        this.build();
        return this.structAlignment;
    }

    protected void orderFields(List<FieldIO> fields) {
        Collections.sort(fields, new Comparator<FieldIO>(){

            @Override
            public int compare(FieldIO o1, FieldIO o2) {
                if (o1.declaringClass.isAssignableFrom(o2.declaringClass)) {
                    return -1;
                }
                if (o2.declaringClass.isAssignableFrom(o1.declaringClass)) {
                    return -1;
                }
                assert (o1.declaringClass.equals(o2.declaringClass));
                return o1.index - o2.index;
            }
        });
    }

    protected boolean acceptFieldGetter(Method method) {
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        int modifiers = method.getModifiers();
        return Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers);
    }

    protected FieldIO newFieldIO() {
        return new FieldIO();
    }

    protected FieldIO createFieldIO(Method getter) {
        FieldIO field = this.newFieldIO();
        field.valueType = getter.getGenericReturnType();
        field.valueClass = getter.getReturnType();
        field.declaringClass = getter.getDeclaringClass();
        String name = getter.getName();
        if (name.matches("get[A-Z].*")) {
            name = Character.toLowerCase(name.charAt(3)) + name.substring(4);
        }
        field.name = name;
        com.nativelibs4java.runtime.ann.jna.Field fil = getter.getAnnotation(com.nativelibs4java.runtime.ann.jna.Field.class);
        Bits bits = getter.getAnnotation(Bits.class);
        Length arr = getter.getAnnotation(Length.class);
        if (fil != null) {
            field.index = fil.value();
        }
        if (bits != null) {
            field.bitLength = bits.value();
        }
        if (arr != null) {
            field.arraySize = arr.value();
        }
        field.isWide = getter.getAnnotation(Wide.class) != null;
        field.isByValue = getter.getAnnotation(ByValue.class) != null;
        return field;
    }

    protected List<FieldIO> listFields() {
        ArrayList<FieldIO> list = new ArrayList<FieldIO>();
        for (Method method : this.structClass.getMethods()) {
            FieldIO io;
            if (!this.acceptFieldGetter(method) || (io = this.createFieldIO(method)) == null) continue;
            list.add(io);
        }
        ArrayList<Class<S>> classes = new ArrayList<Class<S>>();
        Class<S> c = this.structClass;
        do {
            c = c.getSuperclass();
            classes.add(c);
        } while (Struct.class.isAssignableFrom(c));
        Collections.reverse(classes);
        for (Class clazz : classes) {
            for (Field field : this.structClass.getDeclaredFields()) {
            }
        }
        return list;
    }

    protected int primTypeLength(Class<?> primType) {
        if (primType == Integer.TYPE) {
            return 4;
        }
        if (primType == Long.TYPE) {
            return 8;
        }
        if (primType == Short.TYPE) {
            return 2;
        }
        if (primType == Byte.TYPE) {
            return 1;
        }
        if (primType == Float.TYPE) {
            return 4;
        }
        if (primType == Double.TYPE) {
            return 8;
        }
        throw new UnsupportedOperationException("Field type " + primType.getName() + " not supported yet");
    }

    protected FieldIO[] computeStructLayout() {
        List<FieldIO> list = this.listFields();
        this.orderFields(list);
        Alignment alignment = this.structClass.getAnnotation(Alignment.class);
        this.structAlignment = alignment != null ? alignment.value() : 1;
        int refreshableFieldCount = 0;
        this.structSize = 0;
        int cumulativeBitOffset = 0;
        for (FieldIO field : list) {
            field.byteOffset = this.structSize;
            if (field.valueClass.isPrimitive()) {
                field.byteLength = this.primTypeLength(field.valueClass);
            } else if (Struct.class.isAssignableFrom(field.valueClass)) {
                if (field.isByValue) {
                    field.byteLength = Pointer.SIZE;
                } else {
                    StructIO<?> io = StructIO.getInstance(field.valueClass);
                    field.byteLength = io.getStructSize();
                }
                field.refreshableFieldIndex = refreshableFieldCount++;
            } else if (Pointer.class.equals(field.valueClass)) {
                field.byteLength = Pointer.SIZE;
            } else if (PointerType.class.isAssignableFrom(field.valueClass)) {
                field.byteLength = Pointer.SIZE;
                field.refreshableFieldIndex = refreshableFieldCount++;
            } else if (Buffer.class.isAssignableFrom(field.valueClass)) {
                if (field.valueClass == IntBuffer.class) {
                    field.byteLength = 4;
                } else if (field.valueClass == LongBuffer.class) {
                    field.byteLength = 8;
                } else if (field.valueClass == ShortBuffer.class) {
                    field.byteLength = 2;
                } else if (field.valueClass == ByteBuffer.class) {
                    field.byteLength = 1;
                } else if (field.valueClass == FloatBuffer.class) {
                    field.byteLength = 4;
                } else if (field.valueClass == DoubleBuffer.class) {
                    field.byteLength = 8;
                } else {
                    throw new UnsupportedOperationException("Field array type " + field.valueClass.getName() + " not supported yet");
                }
                field.refreshableFieldIndex = refreshableFieldCount++;
            } else if (field.valueClass.isArray() && field.valueClass.getComponentType().isPrimitive()) {
                field.byteLength = this.primTypeLength(field.valueClass.getComponentType());
            } else {
                throw new UnsupportedOperationException("Field type " + field.valueClass.getName() + " not supported yet");
            }
            if (field.bitLength < 0) {
                if (cumulativeBitOffset != 0) {
                    cumulativeBitOffset = 0;
                    ++this.structSize;
                }
                int fieldAlignment = field.byteLength;
                this.structAlignment = Math.max(this.structAlignment, fieldAlignment);
                this.structSize = this.alignSize(this.structSize, fieldAlignment);
            }
            field.byteOffset = this.structSize;
            field.bitOffset = cumulativeBitOffset;
            if (field.bitLength >= 0) {
                field.byteLength = (field.bitLength >>> 3) + ((field.bitLength & 7) != 0 ? 1 : 0);
                this.structSize += (cumulativeBitOffset += field.bitLength) >>> 3;
                cumulativeBitOffset &= 7;
                continue;
            }
            this.structSize += field.arraySize * field.byteLength;
        }
        if (cumulativeBitOffset > 0) {
            this.structSize = this.alignSize(this.structSize + 1, this.structAlignment);
        } else if (this.structSize > 0) {
            this.structSize = this.alignSize(this.structSize, this.structAlignment);
        }
        ArrayList<FieldIO> filtered = new ArrayList<FieldIO>();
        for (FieldIO fio : list) {
            if (!fio.declaringClass.equals(this.structClass)) continue;
            filtered.add(fio);
        }
        return filtered.toArray(new FieldIO[filtered.size()]);
    }

    public Type getFieldType(int fieldIndex) {
        return this.fields[fieldIndex].valueType;
    }

    public void read(S struct) {
    }

    public void write(S struct) {
    }

    public Pointer getPointerField(int fieldIndex, S struct) {
        FieldIO field = this.fields[fieldIndex];
        assert (!field.isBitField);
        assert (Pointer.class.isAssignableFrom(field.valueClass));
        return ((Struct)struct).getPointer().getPointer(field.byteOffset);
    }

    public void setPointerField(int fieldIndex, S struct, Pointer p) {
        FieldIO field = this.fields[fieldIndex];
        assert (!field.isBitField);
        assert (Pointer.class.isAssignableFrom(field.valueClass));
        ((Struct)struct).getPointer().setPointer(field.byteOffset, p);
    }

    public String getStringField(int fieldIndex, S struct) {
        FieldIO field = this.fields[fieldIndex];
        assert (field.valueClass.equals(String.class));
        return ((Struct)struct).getPointer().getString(field.byteOffset, field.isWide);
    }

    public void setStringField(int fieldIndex, S struct, String value) {
        FieldIO field = this.fields[fieldIndex];
        assert (field.valueClass.equals(String.class));
        ((Struct)struct).getPointer().setString(field.byteOffset, value, field.isWide);
    }

    public String[] getStringArrayField(int fieldIndex, S struct) {
        FieldIO field = this.fields[fieldIndex];
        assert (field.valueClass.equals(String[].class));
        String[] strings = new String[field.arraySize];
        Pointer p = ((Struct)struct).getPointer();
        int len = field.arraySize;
        for (int i = 0; i < len; ++i) {
            int offset = field.byteOffset + i * Pointer.SIZE;
            strings[i] = p.getString(offset, field.isWide);
        }
        return strings;
    }

    public void setStringArrayField(int fieldIndex, S struct, String[] value) {
        FieldIO field = this.fields[fieldIndex];
        assert (field.valueClass.equals(String[].class));
        assert (field.arraySize == value.length);
        Pointer p = ((Struct)struct).getPointer();
        int len = value.length;
        for (int i = 0; i < len; ++i) {
            String s = value[i];
            int offset = field.byteOffset + i * Pointer.SIZE;
            if (s == null) {
                p.setPointer(offset, null);
                continue;
            }
            p.setString(offset, s);
        }
    }

    public <P extends PointerType> P getPointerTypeField(int fieldIndex, S struct) {
        FieldIO field = this.fields[fieldIndex];
        assert (!field.isBitField);
        assert (PointerType.class.isAssignableFrom(field.valueClass));
        PointerType p = (PointerType)((Struct)struct).refreshableFields[field.refreshableFieldIndex];
        Pointer ptr = ((Struct)struct).getPointer().getPointer(field.byteOffset);
        try {
            if (p == null) {
                p = (PointerType)field.valueClass.getConstructor(Pointer.class).newInstance(ptr);
                ((Struct)struct).refreshableFields[field.refreshableFieldIndex] = p;
            } else {
                p.setPointer(ptr);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to instantiate pointer of type " + field.valueClass.getName(), ex);
        }
        return (P)p;
    }

    public <P extends PointerType> void setPointerTypeField(int fieldIndex, S struct, P p) {
        FieldIO field = this.fields[fieldIndex];
        assert (!field.isBitField);
        assert (PointerType.class.isAssignableFrom(field.valueClass));
        ((Struct)struct).refreshableFields[field.refreshableFieldIndex] = p;
        ((Struct)struct).getPointer().setPointer(field.byteOffset, p.getPointer());
    }

    public <F extends Struct<F>> void setStructField(int fieldIndex, S struct, Class<F> fieldClass, F fieldValue) {
        FieldIO field = this.fields[fieldIndex];
        assert (fieldClass.equals(field.valueClass));
        if (field.isByValue) {
            if (fieldValue == null) {
                throw new IllegalArgumentException("By-value struct fields cannot be set to null");
            }
        } else {
            ((Struct)struct).refreshableFields[field.refreshableFieldIndex] = fieldValue;
            ((Struct)struct).getPointer().setPointer(field.byteOffset, fieldValue.getPointer());
        }
    }

    public <F extends Struct<F>> F getStructField(int fieldIndex, S struct, Class<F> fieldClass) {
        FieldIO field = this.fields[fieldIndex];
        assert (fieldClass.equals(field.valueClass));
        Struct fieldValue = (Struct)((Struct)struct).refreshableFields[field.refreshableFieldIndex];
        if (fieldValue == null) {
            try {
                fieldValue = (Struct)fieldClass.newInstance();
                ((Struct)struct).refreshableFields[field.refreshableFieldIndex] = fieldValue;
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to instantiate struct of type " + fieldClass.getName(), ex);
            }
        }
        fieldValue.setPointer(((Struct)struct).getPointer().share(field.byteOffset));
        return (F)fieldValue;
    }

    public boolean getBoolField(int fieldIndex, S struct) {
        return this.getByteField(fieldIndex, struct) != 0;
    }

    public void setBoolField(int fieldIndex, S struct, boolean fieldValue) {
        this.setByteField(fieldIndex, struct, (byte)(fieldValue ? 1 : 0));
    }

    public int getIntField(int fieldIndex, S struct) {
        FieldIO field = this.fields[fieldIndex];
        assert (field.byteLength == 4);
        assert (Integer.TYPE.equals(field.valueClass) || Integer.class.equals(field.valueClass));
        if (field.isBitField) {
            return BitFields.getPrimitiveValue(((Struct)struct).getPointer(), field.byteOffset, field.bitOffset, field.bitLength, Integer.TYPE);
        }
        return ((Struct)struct).getPointer().getInt(field.byteOffset);
    }

    public void setIntField(int fieldIndex, S struct, int value) {
        FieldIO field = this.fields[fieldIndex];
        assert (field.byteLength == 4);
        assert (Integer.TYPE.equals(field.valueClass) || Integer.class.equals(field.valueClass));
        if (field.isBitField) {
            BitFields.setPrimitiveValue(((Struct)struct).getPointer(), field.byteOffset, field.bitOffset, field.bitLength, value, Integer.TYPE);
        } else {
            ((Struct)struct).getPointer().setInt(field.byteOffset, value);
        }
    }

    public IntBuffer getIntBufferField(int fieldIndex, S struct) {
        FieldIO field = this.fields[fieldIndex];
        IntBuffer b = (IntBuffer)((Struct)struct).refreshableFields[field.refreshableFieldIndex];
        if (b == null || !b.isDirect() || !((Struct)struct).getPointer().share(field.byteOffset).equals(Native.getDirectBufferPointer(b))) {
            int len = field.arraySize * field.byteLength;
            b = ((Struct)struct).getPointer().getByteBuffer(field.byteOffset, len).asIntBuffer();
            ((Struct)struct).refreshableFields[field.refreshableFieldIndex] = b;
        }
        return b;
    }

    public void setIntBufferField(int fieldIndex, S struct, IntBuffer fieldValue) {
        FieldIO field = this.fields[fieldIndex];
        if (fieldValue == null) {
            throw new IllegalArgumentException("By-value struct fields cannot be set to null");
        }
        assert (fieldValue.capacity() >= field.arraySize);
        ((Struct)struct).refreshableFields[field.refreshableFieldIndex] = fieldValue;
        int len = field.arraySize * field.byteLength;
        ((Struct)struct).getPointer().getByteBuffer(field.byteOffset, len).asIntBuffer().put(fieldValue.duplicate());
    }

    public int[] getIntArrayField(int fieldIndex, S struct) {
        FieldIO field = this.fields[fieldIndex];
        return ((Struct)struct).getPointer().getIntArray(field.byteOffset, field.arraySize);
    }

    public void setIntArrayField(int fieldIndex, S struct, int[] fieldValue) {
        FieldIO field = this.fields[fieldIndex];
        if (fieldValue == null) {
            throw new IllegalArgumentException("By-value struct fields cannot be set to null");
        }
        ((Struct)struct).getPointer().write((long)field.byteOffset, fieldValue, 0, field.arraySize);
    }

    public long getLongField(int fieldIndex, S struct) {
        FieldIO field = this.fields[fieldIndex];
        assert (field.byteLength == 8);
        assert (Long.TYPE.equals(field.valueClass) || Long.class.equals(field.valueClass));
        if (field.isBitField) {
            return BitFields.getPrimitiveValue(((Struct)struct).getPointer(), field.byteOffset, field.bitOffset, field.bitLength, Long.TYPE);
        }
        return ((Struct)struct).getPointer().getLong(field.byteOffset);
    }

    public void setLongField(int fieldIndex, S struct, long value) {
        FieldIO field = this.fields[fieldIndex];
        assert (field.byteLength == 8);
        assert (Long.TYPE.equals(field.valueClass) || Long.class.equals(field.valueClass));
        if (field.isBitField) {
            BitFields.setPrimitiveValue(((Struct)struct).getPointer(), field.byteOffset, field.bitOffset, field.bitLength, value, Long.TYPE);
        } else {
            ((Struct)struct).getPointer().setLong(field.byteOffset, value);
        }
    }

    public LongBuffer getLongBufferField(int fieldIndex, S struct) {
        FieldIO field = this.fields[fieldIndex];
        LongBuffer b = (LongBuffer)((Struct)struct).refreshableFields[field.refreshableFieldIndex];
        if (b == null || !b.isDirect() || !((Struct)struct).getPointer().share(field.byteOffset).equals(Native.getDirectBufferPointer(b))) {
            int len = field.arraySize * field.byteLength;
            b = ((Struct)struct).getPointer().getByteBuffer(field.byteOffset, len).asLongBuffer();
            ((Struct)struct).refreshableFields[field.refreshableFieldIndex] = b;
        }
        return b;
    }

    public void setLongBufferField(int fieldIndex, S struct, LongBuffer fieldValue) {
        FieldIO field = this.fields[fieldIndex];
        if (fieldValue == null) {
            throw new IllegalArgumentException("By-value struct fields cannot be set to null");
        }
        assert (fieldValue.capacity() >= field.arraySize);
        ((Struct)struct).refreshableFields[field.refreshableFieldIndex] = fieldValue;
        int len = field.arraySize * field.byteLength;
        ((Struct)struct).getPointer().getByteBuffer(field.byteOffset, len).asLongBuffer().put(fieldValue.duplicate());
    }

    public long[] getLongArrayField(int fieldIndex, S struct) {
        FieldIO field = this.fields[fieldIndex];
        return ((Struct)struct).getPointer().getLongArray(field.byteOffset, field.arraySize);
    }

    public void setLongArrayField(int fieldIndex, S struct, long[] fieldValue) {
        FieldIO field = this.fields[fieldIndex];
        if (fieldValue == null) {
            throw new IllegalArgumentException("By-value struct fields cannot be set to null");
        }
        ((Struct)struct).getPointer().write((long)field.byteOffset, fieldValue, 0, field.arraySize);
    }

    public short getShortField(int fieldIndex, S struct) {
        FieldIO field = this.fields[fieldIndex];
        assert (field.byteLength == 2);
        assert (Short.TYPE.equals(field.valueClass) || Short.class.equals(field.valueClass));
        if (field.isBitField) {
            return BitFields.getPrimitiveValue(((Struct)struct).getPointer(), field.byteOffset, field.bitOffset, field.bitLength, Short.TYPE);
        }
        return ((Struct)struct).getPointer().getShort(field.byteOffset);
    }

    public void setShortField(int fieldIndex, S struct, short value) {
        FieldIO field = this.fields[fieldIndex];
        assert (field.byteLength == 2);
        assert (Short.TYPE.equals(field.valueClass) || Short.class.equals(field.valueClass));
        if (field.isBitField) {
            BitFields.setPrimitiveValue(((Struct)struct).getPointer(), field.byteOffset, field.bitOffset, field.bitLength, value, Short.TYPE);
        } else {
            ((Struct)struct).getPointer().setShort(field.byteOffset, value);
        }
    }

    public ShortBuffer getShortBufferField(int fieldIndex, S struct) {
        FieldIO field = this.fields[fieldIndex];
        ShortBuffer b = (ShortBuffer)((Struct)struct).refreshableFields[field.refreshableFieldIndex];
        if (b == null || !b.isDirect() || !((Struct)struct).getPointer().share(field.byteOffset).equals(Native.getDirectBufferPointer(b))) {
            int len = field.arraySize * field.byteLength;
            b = ((Struct)struct).getPointer().getByteBuffer(field.byteOffset, len).asShortBuffer();
            ((Struct)struct).refreshableFields[field.refreshableFieldIndex] = b;
        }
        return b;
    }

    public void setShortBufferField(int fieldIndex, S struct, ShortBuffer fieldValue) {
        FieldIO field = this.fields[fieldIndex];
        if (fieldValue == null) {
            throw new IllegalArgumentException("By-value struct fields cannot be set to null");
        }
        assert (fieldValue.capacity() >= field.arraySize);
        ((Struct)struct).refreshableFields[field.refreshableFieldIndex] = fieldValue;
        int len = field.arraySize * field.byteLength;
        ((Struct)struct).getPointer().getByteBuffer(field.byteOffset, len).asShortBuffer().put(fieldValue.duplicate());
    }

    public short[] getShortArrayField(int fieldIndex, S struct) {
        FieldIO field = this.fields[fieldIndex];
        return ((Struct)struct).getPointer().getShortArray(field.byteOffset, field.arraySize);
    }

    public void setShortArrayField(int fieldIndex, S struct, short[] fieldValue) {
        FieldIO field = this.fields[fieldIndex];
        if (fieldValue == null) {
            throw new IllegalArgumentException("By-value struct fields cannot be set to null");
        }
        ((Struct)struct).getPointer().write((long)field.byteOffset, fieldValue, 0, field.arraySize);
    }

    public byte getByteField(int fieldIndex, S struct) {
        FieldIO field = this.fields[fieldIndex];
        assert (field.byteLength == 1);
        assert (Byte.TYPE.equals(field.valueClass) || Byte.class.equals(field.valueClass));
        if (field.isBitField) {
            return BitFields.getPrimitiveValue(((Struct)struct).getPointer(), field.byteOffset, field.bitOffset, field.bitLength, Byte.TYPE);
        }
        return ((Struct)struct).getPointer().getByte(field.byteOffset);
    }

    public void setByteField(int fieldIndex, S struct, byte value) {
        FieldIO field = this.fields[fieldIndex];
        assert (field.byteLength == 1);
        assert (Byte.TYPE.equals(field.valueClass) || Byte.class.equals(field.valueClass));
        if (field.isBitField) {
            BitFields.setPrimitiveValue(((Struct)struct).getPointer(), field.byteOffset, field.bitOffset, field.bitLength, value, Byte.TYPE);
        } else {
            ((Struct)struct).getPointer().setByte(field.byteOffset, value);
        }
    }

    public ByteBuffer getByteBufferField(int fieldIndex, S struct) {
        FieldIO field = this.fields[fieldIndex];
        ByteBuffer b = (ByteBuffer)((Struct)struct).refreshableFields[field.refreshableFieldIndex];
        if (b == null || !b.isDirect() || !((Struct)struct).getPointer().share(field.byteOffset).equals(Native.getDirectBufferPointer(b))) {
            int len = field.arraySize * field.byteLength;
            b = ((Struct)struct).getPointer().getByteBuffer(field.byteOffset, len);
            ((Struct)struct).refreshableFields[field.refreshableFieldIndex] = b;
        }
        return b;
    }

    public void setByteBufferField(int fieldIndex, S struct, ByteBuffer fieldValue) {
        FieldIO field = this.fields[fieldIndex];
        if (fieldValue == null) {
            throw new IllegalArgumentException("By-value struct fields cannot be set to null");
        }
        assert (fieldValue.capacity() >= field.arraySize);
        ((Struct)struct).refreshableFields[field.refreshableFieldIndex] = fieldValue;
        int len = field.arraySize * field.byteLength;
        ((Struct)struct).getPointer().getByteBuffer(field.byteOffset, len).put(fieldValue.duplicate());
    }

    public byte[] getByteArrayField(int fieldIndex, S struct) {
        FieldIO field = this.fields[fieldIndex];
        return ((Struct)struct).getPointer().getByteArray(field.byteOffset, field.arraySize);
    }

    public void setByteArrayField(int fieldIndex, S struct, byte[] fieldValue) {
        FieldIO field = this.fields[fieldIndex];
        if (fieldValue == null) {
            throw new IllegalArgumentException("By-value struct fields cannot be set to null");
        }
        ((Struct)struct).getPointer().write((long)field.byteOffset, fieldValue, 0, field.arraySize);
    }

    public char getCharField(int fieldIndex, S struct) {
        FieldIO field = this.fields[fieldIndex];
        assert (field.byteLength == 2);
        assert (Character.TYPE.equals(field.valueClass) || Character.class.equals(field.valueClass));
        if (field.isBitField) {
            return BitFields.getPrimitiveValue(((Struct)struct).getPointer(), field.byteOffset, field.bitOffset, field.bitLength, Character.TYPE).charValue();
        }
        return ((Struct)struct).getPointer().getChar(field.byteOffset);
    }

    public void setCharField(int fieldIndex, S struct, char value) {
        FieldIO field = this.fields[fieldIndex];
        assert (field.byteLength == 2);
        assert (Character.TYPE.equals(field.valueClass) || Character.class.equals(field.valueClass));
        if (field.isBitField) {
            BitFields.setPrimitiveValue(((Struct)struct).getPointer(), field.byteOffset, field.bitOffset, field.bitLength, Character.valueOf(value), Character.TYPE);
        } else {
            ((Struct)struct).getPointer().setChar(field.byteOffset, value);
        }
    }

    public CharBuffer getCharBufferField(int fieldIndex, S struct) {
        FieldIO field = this.fields[fieldIndex];
        CharBuffer b = (CharBuffer)((Struct)struct).refreshableFields[field.refreshableFieldIndex];
        if (b == null || !b.isDirect() || !((Struct)struct).getPointer().share(field.byteOffset).equals(Native.getDirectBufferPointer(b))) {
            int len = field.arraySize * field.byteLength;
            b = ((Struct)struct).getPointer().getByteBuffer(field.byteOffset, len).asCharBuffer();
            ((Struct)struct).refreshableFields[field.refreshableFieldIndex] = b;
        }
        return b;
    }

    public void setCharBufferField(int fieldIndex, S struct, CharBuffer fieldValue) {
        FieldIO field = this.fields[fieldIndex];
        if (fieldValue == null) {
            throw new IllegalArgumentException("By-value struct fields cannot be set to null");
        }
        assert (fieldValue.capacity() >= field.arraySize);
        ((Struct)struct).refreshableFields[field.refreshableFieldIndex] = fieldValue;
        int len = field.arraySize * field.byteLength;
        ((Struct)struct).getPointer().getByteBuffer(field.byteOffset, len).asCharBuffer().put(fieldValue.duplicate());
    }

    public char[] getCharArrayField(int fieldIndex, S struct) {
        FieldIO field = this.fields[fieldIndex];
        return ((Struct)struct).getPointer().getCharArray(field.byteOffset, field.arraySize);
    }

    public void setCharArrayField(int fieldIndex, S struct, char[] fieldValue) {
        FieldIO field = this.fields[fieldIndex];
        if (fieldValue == null) {
            throw new IllegalArgumentException("By-value struct fields cannot be set to null");
        }
        ((Struct)struct).getPointer().write((long)field.byteOffset, fieldValue, 0, field.arraySize);
    }

    public float getFloatField(int fieldIndex, S struct) {
        FieldIO field = this.fields[fieldIndex];
        assert (field.byteLength == 4);
        assert (Float.TYPE.equals(field.valueClass) || Float.class.equals(field.valueClass));
        if (field.isBitField) {
            return BitFields.getPrimitiveValue(((Struct)struct).getPointer(), field.byteOffset, field.bitOffset, field.bitLength, Float.TYPE).floatValue();
        }
        return ((Struct)struct).getPointer().getFloat(field.byteOffset);
    }

    public void setFloatField(int fieldIndex, S struct, float value) {
        FieldIO field = this.fields[fieldIndex];
        assert (field.byteLength == 4);
        assert (Float.TYPE.equals(field.valueClass) || Float.class.equals(field.valueClass));
        if (field.isBitField) {
            BitFields.setPrimitiveValue(((Struct)struct).getPointer(), field.byteOffset, field.bitOffset, field.bitLength, Float.valueOf(value), Float.TYPE);
        } else {
            ((Struct)struct).getPointer().setFloat(field.byteOffset, value);
        }
    }

    public FloatBuffer getFloatBufferField(int fieldIndex, S struct) {
        FieldIO field = this.fields[fieldIndex];
        FloatBuffer b = (FloatBuffer)((Struct)struct).refreshableFields[field.refreshableFieldIndex];
        if (b == null || !b.isDirect() || !((Struct)struct).getPointer().share(field.byteOffset).equals(Native.getDirectBufferPointer(b))) {
            int len = field.arraySize * field.byteLength;
            b = ((Struct)struct).getPointer().getByteBuffer(field.byteOffset, len).asFloatBuffer();
            ((Struct)struct).refreshableFields[field.refreshableFieldIndex] = b;
        }
        return b;
    }

    public void setFloatBufferField(int fieldIndex, S struct, FloatBuffer fieldValue) {
        FieldIO field = this.fields[fieldIndex];
        if (fieldValue == null) {
            throw new IllegalArgumentException("By-value struct fields cannot be set to null");
        }
        assert (fieldValue.capacity() >= field.arraySize);
        ((Struct)struct).refreshableFields[field.refreshableFieldIndex] = fieldValue;
        int len = field.arraySize * field.byteLength;
        ((Struct)struct).getPointer().getByteBuffer(field.byteOffset, len).asFloatBuffer().put(fieldValue.duplicate());
    }

    public float[] getFloatArrayField(int fieldIndex, S struct) {
        FieldIO field = this.fields[fieldIndex];
        return ((Struct)struct).getPointer().getFloatArray(field.byteOffset, field.arraySize);
    }

    public void setFloatArrayField(int fieldIndex, S struct, float[] fieldValue) {
        FieldIO field = this.fields[fieldIndex];
        if (fieldValue == null) {
            throw new IllegalArgumentException("By-value struct fields cannot be set to null");
        }
        ((Struct)struct).getPointer().write((long)field.byteOffset, fieldValue, 0, field.arraySize);
    }

    public double getDoubleField(int fieldIndex, S struct) {
        FieldIO field = this.fields[fieldIndex];
        assert (field.byteLength == 8);
        assert (Double.TYPE.equals(field.valueClass) || Double.class.equals(field.valueClass));
        if (field.isBitField) {
            return BitFields.getPrimitiveValue(((Struct)struct).getPointer(), field.byteOffset, field.bitOffset, field.bitLength, Double.TYPE);
        }
        return ((Struct)struct).getPointer().getDouble(field.byteOffset);
    }

    public void setDoubleField(int fieldIndex, S struct, double value) {
        FieldIO field = this.fields[fieldIndex];
        assert (field.byteLength == 8);
        assert (Double.TYPE.equals(field.valueClass) || Double.class.equals(field.valueClass));
        if (field.isBitField) {
            BitFields.setPrimitiveValue(((Struct)struct).getPointer(), field.byteOffset, field.bitOffset, field.bitLength, value, Double.TYPE);
        } else {
            ((Struct)struct).getPointer().setDouble(field.byteOffset, value);
        }
    }

    public DoubleBuffer getDoubleBufferField(int fieldIndex, S struct) {
        FieldIO field = this.fields[fieldIndex];
        DoubleBuffer b = (DoubleBuffer)((Struct)struct).refreshableFields[field.refreshableFieldIndex];
        if (b == null || !b.isDirect() || !((Struct)struct).getPointer().share(field.byteOffset).equals(Native.getDirectBufferPointer(b))) {
            int len = field.arraySize * field.byteLength;
            b = ((Struct)struct).getPointer().getByteBuffer(field.byteOffset, len).asDoubleBuffer();
            ((Struct)struct).refreshableFields[field.refreshableFieldIndex] = b;
        }
        return b;
    }

    public void setDoubleBufferField(int fieldIndex, S struct, DoubleBuffer fieldValue) {
        FieldIO field = this.fields[fieldIndex];
        if (fieldValue == null) {
            throw new IllegalArgumentException("By-value struct fields cannot be set to null");
        }
        assert (fieldValue.capacity() >= field.arraySize);
        ((Struct)struct).refreshableFields[field.refreshableFieldIndex] = fieldValue;
        int len = field.arraySize * field.byteLength;
        ((Struct)struct).getPointer().getByteBuffer(field.byteOffset, len).asDoubleBuffer().put(fieldValue.duplicate());
    }

    public double[] getDoubleArrayField(int fieldIndex, S struct) {
        FieldIO field = this.fields[fieldIndex];
        return ((Struct)struct).getPointer().getDoubleArray(field.byteOffset, field.arraySize);
    }

    public void setDoubleArrayField(int fieldIndex, S struct, double[] fieldValue) {
        FieldIO field = this.fields[fieldIndex];
        if (fieldValue == null) {
            throw new IllegalArgumentException("By-value struct fields cannot be set to null");
        }
        ((Struct)struct).getPointer().write((long)field.byteOffset, fieldValue, 0, field.arraySize);
    }

    public static class FieldIO {
        String name;
        int index = -1;
        int byteOffset;
        int byteLength;
        int bitOffset;
        int bitLength = -1;
        int arraySize = 1;
        boolean isBitField;
        boolean isByValue;
        boolean isNativeSize;
        boolean isCLong;
        boolean isWide;
        int refreshableFieldIndex = -1;
        Type valueType;
        Class<?> valueClass;
        Class<?> declaringClass;
    }
}

