/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.runtime.jna;

import com.nativelibs4java.runtime.jna.Struct;
import com.nativelibs4java.runtime.jna.StructIOWithNIO;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;

public class StructWithNIO<S extends StructWithNIO<S>>
extends Struct<S> {
    protected ByteBuffer buffer;

    public StructWithNIO(StructIOWithNIO io) {
        super(io);
    }

    public synchronized ByteBuffer getBuffer() {
        if (this.buffer == null) {
            throw new UnsupportedOperationException("Struct is not backed by an NIO buffer (TODO: implement creation of a buffer out of a pointer)");
        }
        return this.buffer;
    }

    @Override
    public synchronized S setPointer(Pointer pointer) {
        super.setPointer(pointer);
        this.buffer = null;
        return (S)this;
    }

    public synchronized void setBuffer(ByteBuffer buffer) {
        Pointer pointer = null;
        if (buffer == null || buffer.isDirect() && ((pointer = Native.getDirectBufferPointer(buffer)) == null || pointer.equals(Pointer.NULL))) {
            throw new NullPointerException("Cannot set null pointer as struct address !");
        }
        this.buffer = buffer;
        this.pointer = pointer;
    }

    public synchronized boolean isDirect() {
        return this.pointer != null;
    }

    public synchronized boolean hasBuffer() {
        return this.buffer != null;
    }

    @Override
    public S clone() {
        if (!this.isDirect()) {
            throw new UnsupportedOperationException("NIO clone not implemented yet");
        }
        return (S)((StructWithNIO)super.clone());
    }
}

