/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class SystemUtils {
    static String osName = System.getProperty("os.name");

    public static final void runSystemCommand(String[] cmd) throws NoSuchMethodException {
        try {
            Runtime.getRuntime().exec(cmd);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new NoSuchMethodException(ex.toString());
        }
    }

    public static final void runSystemCommand(String cmd) throws NoSuchMethodException {
        try {
            Runtime.getRuntime().exec(cmd);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new NoSuchMethodException(ex.toString());
        }
    }

    public static boolean isMacOSX() {
        return osName.equals("Mac OS X");
    }

    public static boolean isWindows() {
        return osName.indexOf("Windows") >= 0;
    }

    public static boolean isLinux() {
        return osName.indexOf("Linux") >= 0;
    }

    public static boolean isSolaris() {
        return osName.indexOf("Solaris") >= 0 || osName.indexOf("SunOS") >= 0;
    }

    public static boolean isUnix() {
        return File.separatorChar == '/';
    }

    public static final void runSystemOpenURL(URL url) throws NoSuchMethodException, IOException {
        if (SystemUtils.isMacOSX()) {
            SystemUtils.runSystemCommand(new String[]{"open", url.toString()});
        } else if (SystemUtils.isWindows()) {
            SystemUtils.runSystemCommand(new String[]{"rundll32", "url.dll,FileProtocolHandler", url.toString()});
        } else if (SystemUtils.isLinux()) {
            if (SystemUtils.hasUnixCommand("gnome-open")) {
                SystemUtils.runSystemCommand(new String[]{"gnome-open", url.toString()});
            } else {
                SystemUtils.runSystemCommand(new String[]{"konqueror", url.toString()});
            }
        } else if (url.getProtocol().equals("file")) {
            SystemUtils.runSystemOpenFileParent(new File(url.getFile()));
        } else {
            SystemUtils.runSystemCommand(new String[]{"mozilla", url.toString()});
        }
    }

    public static final boolean hasUnixCommand(String name) {
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"which", name});
            return p.waitFor() == 0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static final void runSystemOpenFileWith(File fileToOpen) throws NoSuchMethodException, IOException {
        SystemUtils.runSystemCommand(new String[]{"RUNDLL32.EXE", "SHELL32.DLL,OpenAs_RunDLL", fileToOpen.getCanonicalPath()});
    }

    public static final void runSystemOpenFile(File fileToOpen) throws NoSuchMethodException, IOException {
        if (SystemUtils.isMacOSX()) {
            SystemUtils.runSystemCommand(new String[]{"open", fileToOpen.getCanonicalPath()});
        } else if (SystemUtils.isWindows()) {
            SystemUtils.runSystemCommand(new String[]{"start", fileToOpen.getCanonicalPath()});
        } else if (SystemUtils.isLinux()) {
            if (SystemUtils.hasUnixCommand("gnome-open")) {
                SystemUtils.runSystemCommand(new String[]{"gnome-open", fileToOpen.getCanonicalPath()});
            } else {
                SystemUtils.runSystemCommand(new String[]{"konqueror", fileToOpen.getCanonicalPath()});
            }
        } else if (SystemUtils.isSolaris() && fileToOpen.isDirectory()) {
            SystemUtils.runSystemCommand(new String[]{"/usr/dt/bin/dtfile", "-folder", fileToOpen.getCanonicalPath()});
        }
    }

    public static final void runSystemOpenDirectory(File file) throws NoSuchMethodException, IOException {
        if (SystemUtils.isWindows()) {
            SystemUtils.runSystemCommand(new String[]{"explorer", file.getCanonicalPath()});
        } else {
            SystemUtils.runSystemOpenFile(file);
        }
    }

    public static final void runImageEditor(File imageFile) throws NoSuchMethodException, IOException {
        if (!imageFile.exists()) {
            throw new FileNotFoundException(imageFile.toString());
        }
        if (!SystemUtils.isWindows()) {
            throw new NoSuchMethodException("Implement me ! Image editor on " + osName);
        }
        Runtime.getRuntime().exec(new String[]{"mspaint.exe", imageFile.getAbsolutePath()});
    }

    public static final void runSystemOpenFileParent(File fileToShow) throws NoSuchMethodException, IOException {
        if (SystemUtils.isMacOSX()) {
            SystemUtils.runSystemCommand(new String[]{"open", fileToShow.getParentFile().getAbsolutePath()});
        } else if (SystemUtils.isWindows()) {
            SystemUtils.runSystemCommand("explorer /e,/select,\"" + fileToShow.getCanonicalPath() + "\"");
        } else if (SystemUtils.isLinux()) {
            if (SystemUtils.hasUnixCommand("gnome-open")) {
                SystemUtils.runSystemCommand(new String[]{"gnome-open", fileToShow.getParentFile().getAbsolutePath()});
            } else {
                SystemUtils.runSystemCommand(new String[]{"konqueror", fileToShow.getParentFile().getAbsolutePath()});
            }
        } else if (SystemUtils.isSolaris()) {
            SystemUtils.runSystemCommand(new String[]{"/usr/dt/bin/dtfile", "-folder", fileToShow.getParentFile().getCanonicalPath()});
        }
    }

    public static final JComponent createFileShowAndOpenWithPanel(final File file) {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("windows") >= 0) {
            JButton bSee = new JButton("Dir.");
            JButton bOpenWith = new JButton("Open with...");
            bSee.setToolTipText("<html><body>Browse directory :<br><code>" + file.getParentFile().toString() + "</code></body></html>");
            bSee.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        SystemUtils.runSystemOpenFileParent(file);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(null, ex.toString(), "Error", 0);
                    }
                    catch (NoSuchMethodException ex) {
                        ex.printStackTrace();
                    }
                }
            });
            bOpenWith.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        SystemUtils.runSystemOpenFileWith(file);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(null, ex.toString(), "Error", 0);
                    }
                    catch (NoSuchMethodException ex) {
                        ex.printStackTrace();
                    }
                }
            });
            Box box = Box.createHorizontalBox();
            box.add(bSee);
            box.add(bOpenWith);
            return box;
        }
        System.err.println("Does not handle OS '" + osName + "'");
        return null;
    }

    public static final JPopupMenu createOpenOpenWithShowDirPopupPanel(final File file) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem miOpen = new JMenuItem("Open");
        JMenuItem miOpenWith = new JMenuItem("Open with...");
        JMenuItem miShowDir = new JMenuItem("Open parent directory");
        boolean isWindows = osName.indexOf("windows") >= 0;
        miShowDir.setToolTipText("<html><body>Browse directory :<br><code>" + file.getParentFile().toString() + "</code></body></html>");
        miShowDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    SystemUtils.runSystemOpenFileParent(file);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(null, ex.toString(), "Error", 0);
                }
                catch (NoSuchMethodException ex) {
                    ex.printStackTrace();
                }
            }
        });
        miOpenWith.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    SystemUtils.runSystemOpenFileWith(file);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(null, ex.toString(), "Error", 0);
                }
                catch (NoSuchMethodException ex) {
                    ex.printStackTrace();
                }
            }
        });
        miOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    SystemUtils.runSystemOpenURL(file.toURI().toURL());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(null, ex.toString(), "Error", 0);
                }
                catch (NoSuchMethodException ex) {
                    ex.printStackTrace();
                }
            }
        });
        menu.add(miOpen);
        if (isWindows) {
            menu.add(miOpenWith);
        }
        menu.addSeparator();
        menu.add(miShowDir);
        return menu;
    }

    public static final boolean addOpenOpenWithShowDirPopupPanel(File file, JComponent component) {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("windows") >= 0) {
            final JPopupMenu menu = SystemUtils.createOpenOpenWithShowDirPopupPanel(file);
            component.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent evt) {
                    if (evt.isPopupTrigger() || evt.getButton() > 1) {
                        menu.show(evt.getComponent(), evt.getX(), evt.getY());
                    }
                }
            });
            return true;
        }
        System.err.println("Does not handle OS '" + osName + "'");
        return false;
    }

    public static boolean isPopupTrigger(MouseEvent e) {
        if (e.isPopupTrigger() || e.getButton() != 1) {
            return true;
        }
        if (SystemUtils.isMacOSX()) {
            return e.isControlDown();
        }
        return false;
    }
}

