/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.util.string;

import com.ochafik.util.listenable.Adapter;
import com.ochafik.util.listenable.Pair;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexUtils {
    static final String[][] simplePatternReplacements = new String[][]{{"(\\.|\\+|\\[|\\]|\\{|\\})", "\\\\."}, {"(\\*|\\?)", ".$1"}, {",", "|"}};
    static final Pattern[] simplePatternReplacementPatterns = new Pattern[simplePatternReplacements.length];

    private static final String replaceSimplePatterByRegex(String string) {
        int i = simplePatternReplacements.length;
        while (i-- != 0) {
            string = simplePatternReplacementPatterns[i].matcher(string).replaceAll(simplePatternReplacements[i][1]);
        }
        return string;
    }

    public static final Pattern simplePatternToRegex(String pattern) {
        try {
            return Pattern.compile(RegexUtils.replaceSimplePatterByRegex(pattern), 66);
        }
        catch (Exception ex) {
            return Pattern.compile(pattern, 82);
        }
    }

    public static String regexReplace(Pattern pattern, String string, MessageFormat replacement) {
        StringBuffer b = new StringBuffer(string.length());
        int iLastCommitted = 0;
        Matcher matcher = pattern.matcher(string);
        while (matcher.find(iLastCommitted)) {
            int start = matcher.start();
            String s = string.substring(iLastCommitted, start);
            String g = matcher.group(0);
            b.append(s);
            if (replacement != null) {
                b.append(replacement.format(RegexUtils.getGroups(matcher), b, (FieldPosition)null));
            } else {
                b.append(g);
            }
            iLastCommitted = start + g.length();
        }
        b.append(string.substring(iLastCommitted));
        return b.toString();
    }

    public static final boolean findLast(Matcher matcher) {
        matcher.reset();
        int n = 0;
        while (matcher.find()) {
            ++n;
        }
        matcher.reset();
        for (int i = 0; i < n; ++i) {
            matcher.find();
        }
        return n > 0;
    }

    public static final List<Pair<String, String[]>> grep(Collection<String> list, Pattern p) {
        ArrayList<Pair<String, String[]>> ret = new ArrayList<Pair<String, String[]>>(list.size());
        for (String s : list) {
            Matcher matcher = p.matcher(s);
            if (!matcher.find()) continue;
            ret.add(new Pair<String, String[]>(s, RegexUtils.getGroups(matcher)));
        }
        return ret;
    }

    public static String[] getGroups(Matcher matcher) {
        String[] groups = new String[matcher.groupCount() + 1];
        int i = groups.length;
        while (i-- != 0) {
            groups[i] = matcher.group(i);
        }
        return groups;
    }

    public static final List<String[]> grep(String s, Pattern p) {
        ArrayList<String[]> ret = new ArrayList<String[]>();
        Matcher matcher = p.matcher(s);
        while (matcher.find()) {
            ret.add(RegexUtils.getGroups(matcher));
        }
        return ret;
    }

    public static final String[] match(String s, Pattern p) {
        Matcher matcher = p.matcher(s);
        if (matcher.matches()) {
            return RegexUtils.getGroups(matcher);
        }
        return null;
    }

    public static List<String[]> find(String string, String pattern) {
        return RegexUtils.find(string, Pattern.compile(pattern));
    }

    public static List<String[]> find(String string, Pattern pattern) {
        LinkedList<String[]> ret = new LinkedList<String[]>();
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            ret.add(RegexUtils.getGroups(matcher));
        }
        return ret;
    }

    public static Collection<String> find(String string, String pattern, int iGroup) {
        return RegexUtils.find(string, Pattern.compile(pattern), iGroup);
    }

    public static Collection<String> find(String string, Pattern pattern, int iGroup) {
        ArrayList<String> ret = new ArrayList<String>();
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            ret.add(matcher.group(iGroup));
        }
        return ret;
    }

    public static String findFirst(String string, Pattern pattern, int iGroup) {
        if (string == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(string);
        return matcher.find() ? matcher.group(iGroup) : null;
    }

    public static String regexReplace(String pat, String text, String rep) {
        return RegexUtils.regexReplace(Pattern.compile(pat), text, new MessageFormat(rep));
    }

    public static String regexReplace(Pattern pattern, String string, Adapter<String[], String> adapter) {
        StringBuffer b = new StringBuffer(string.length());
        int iLastCommitted = 0;
        Matcher matcher = pattern.matcher(string);
        while (matcher.find(iLastCommitted)) {
            int start = matcher.start();
            String s = string.substring(iLastCommitted, start);
            String g = matcher.group(0);
            b.append(s);
            if (adapter != null) {
                b.append(adapter.adapt(RegexUtils.getGroups(matcher)));
            } else {
                b.append(g);
            }
            iLastCommitted = start + g.length();
        }
        b.append(string.substring(iLastCommitted));
        return b.toString();
    }

    static {
        int i = simplePatternReplacements.length;
        while (i-- != 0) {
            RegexUtils.simplePatternReplacementPatterns[i] = Pattern.compile(simplePatternReplacements[i][0]);
        }
    }
}

