(ns clj-money.currencies)

(def default-currency "EUR")

(def rules
  [{:iso-code "AED" :subunit-to-unit 100}
   {:iso-code "AFN" :subunit-to-unit 100}
   {:iso-code "ALL" :subunit-to-unit 100}
   {:iso-code "AMD" :subunit-to-unit 100}
   {:iso-code "ANG" :subunit-to-unit 100}
   {:iso-code "AOA" :subunit-to-unit 100}
   {:iso-code "ARS" :subunit-to-unit 100}
   {:iso-code "AUD" :subunit-to-unit 100}
   {:iso-code "AWG" :subunit-to-unit 100}
   {:iso-code "AZN" :subunit-to-unit 100}
   {:iso-code "BAM" :subunit-to-unit 100}
   {:iso-code "BBD" :subunit-to-unit 100}
   {:iso-code "BDT" :subunit-to-unit 100}
   {:iso-code "BGN" :subunit-to-unit 100}
   {:iso-code "BHD" :subunit-to-unit 1000}
   {:iso-code "BIF" :subunit-to-unit 1}
   {:iso-code "BMD" :subunit-to-unit 100}
   {:iso-code "BND" :subunit-to-unit 100}
   {:iso-code "BOB" :subunit-to-unit 100}
   {:iso-code "BRL" :subunit-to-unit 100}
   {:iso-code "BSD" :subunit-to-unit 100}
   {:iso-code "BTC" :subunit-to-unit 100000000}
   {:iso-code "BTN" :subunit-to-unit 100}
   {:iso-code "BWP" :subunit-to-unit 100}
   {:iso-code "BYN" :subunit-to-unit 100}
   {:iso-code "BYR" :subunit-to-unit 1}
   {:iso-code "BZD" :subunit-to-unit 100}
   {:iso-code "CAD" :subunit-to-unit 100}
   {:iso-code "CDF" :subunit-to-unit 100}
   {:iso-code "CHF" :subunit-to-unit 100}
   {:iso-code "CLF" :subunit-to-unit 10000}
   {:iso-code "CLP" :subunit-to-unit 1}
   {:iso-code "CNY" :subunit-to-unit 100}
   {:iso-code "COP" :subunit-to-unit 100}
   {:iso-code "CRC" :subunit-to-unit 100}
   {:iso-code "CUC" :subunit-to-unit 100}
   {:iso-code "CUP" :subunit-to-unit 100}
   {:iso-code "CVE" :subunit-to-unit 100}
   {:iso-code "CZK" :subunit-to-unit 100}
   {:iso-code "DJF" :subunit-to-unit 1}
   {:iso-code "DKK" :subunit-to-unit 100}
   {:iso-code "DOP" :subunit-to-unit 100}
   {:iso-code "DZD" :subunit-to-unit 100}
   {:iso-code "EEK" :subunit-to-unit 100}
   {:iso-code "EGP" :subunit-to-unit 100}
   {:iso-code "ERN" :subunit-to-unit 100}
   {:iso-code "ETB" :subunit-to-unit 100}
   {:iso-code "EUR" :subunit-to-unit 100 :priority true}
   {:iso-code "FJD" :subunit-to-unit 100}
   {:iso-code "FKP" :subunit-to-unit 100}
   {:iso-code "GBP" :subunit-to-unit 100 :priority true}
   {:iso-code "GEL" :subunit-to-unit 100}
   {:iso-code "GGP" :subunit-to-unit 100}
   {:iso-code "GHS" :subunit-to-unit 100}
   {:iso-code "GIP" :subunit-to-unit 100}
   {:iso-code "GMD" :subunit-to-unit 100}
   {:iso-code "GNF" :subunit-to-unit 1}
   {:iso-code "GTQ" :subunit-to-unit 100}
   {:iso-code "GYD" :subunit-to-unit 100}
   {:iso-code "HKD" :subunit-to-unit 100}
   {:iso-code "HNL" :subunit-to-unit 100}
   {:iso-code "HRK" :subunit-to-unit 100}
   {:iso-code "HTG" :subunit-to-unit 100}
   {:iso-code "HUF" :subunit-to-unit 100}
   {:iso-code "IDR" :subunit-to-unit 100}
   {:iso-code "ILS" :subunit-to-unit 100}
   {:iso-code "IMP" :subunit-to-unit 100}
   {:iso-code "INR" :subunit-to-unit 100}
   {:iso-code "IQD" :subunit-to-unit 1000}
   {:iso-code "IRR" :subunit-to-unit 100}
   {:iso-code "ISK" :subunit-to-unit 1}
   {:iso-code "JEP" :subunit-to-unit 100}
   {:iso-code "JMD" :subunit-to-unit 100}
   {:iso-code "JOD" :subunit-to-unit 1000}
   {:iso-code "JPY" :subunit-to-unit 1}
   {:iso-code "KES" :subunit-to-unit 100}
   {:iso-code "KGS" :subunit-to-unit 100}
   {:iso-code "KHR" :subunit-to-unit 100}
   {:iso-code "KMF" :subunit-to-unit 1}
   {:iso-code "KPW" :subunit-to-unit 100}
   {:iso-code "KRW" :subunit-to-unit 1}
   {:iso-code "KWD" :subunit-to-unit 1000}
   {:iso-code "KYD" :subunit-to-unit 100}
   {:iso-code "KZT" :subunit-to-unit 100}
   {:iso-code "LAK" :subunit-to-unit 100}
   {:iso-code "LBP" :subunit-to-unit 100}
   {:iso-code "LKR" :subunit-to-unit 100}
   {:iso-code "LRD" :subunit-to-unit 100}
   {:iso-code "LSL" :subunit-to-unit 100}
   {:iso-code "LTL" :subunit-to-unit 100}
   {:iso-code "LVL" :subunit-to-unit 100}
   {:iso-code "LYD" :subunit-to-unit 1000}
   {:iso-code "MAD" :subunit-to-unit 100}
   {:iso-code "MDL" :subunit-to-unit 100}
   {:iso-code "MGA" :subunit-to-unit 5}
   {:iso-code "MKD" :subunit-to-unit 100}
   {:iso-code "MMK" :subunit-to-unit 100}
   {:iso-code "MNT" :subunit-to-unit 100}
   {:iso-code "MOP" :subunit-to-unit 100}
   {:iso-code "MRO" :subunit-to-unit 5}
   {:iso-code "MTL" :subunit-to-unit 100}
   {:iso-code "MUR" :subunit-to-unit 100}
   {:iso-code "MVR" :subunit-to-unit 100}
   {:iso-code "MWK" :subunit-to-unit 100}
   {:iso-code "MXN" :subunit-to-unit 100}
   {:iso-code "MYR" :subunit-to-unit 100}
   {:iso-code "MZN" :subunit-to-unit 100}
   {:iso-code "NAD" :subunit-to-unit 100}
   {:iso-code "NGN" :subunit-to-unit 100}
   {:iso-code "NIO" :subunit-to-unit 100}
   {:iso-code "NOK" :subunit-to-unit 100}
   {:iso-code "NPR" :subunit-to-unit 100}
   {:iso-code "NZD" :subunit-to-unit 100}
   {:iso-code "OMR" :subunit-to-unit 1000}
   {:iso-code "PAB" :subunit-to-unit 100}
   {:iso-code "PEN" :subunit-to-unit 100}
   {:iso-code "PGK" :subunit-to-unit 100}
   {:iso-code "PHP" :subunit-to-unit 100}
   {:iso-code "PKR" :subunit-to-unit 100}
   {:iso-code "PLN" :subunit-to-unit 100}
   {:iso-code "PYG" :subunit-to-unit 1}
   {:iso-code "QAR" :subunit-to-unit 100}
   {:iso-code "RON" :subunit-to-unit 100}
   {:iso-code "RSD" :subunit-to-unit 100}
   {:iso-code "RUB" :subunit-to-unit 100}
   {:iso-code "RWF" :subunit-to-unit 1}
   {:iso-code "SAR" :subunit-to-unit 100}
   {:iso-code "SBD" :subunit-to-unit 100}
   {:iso-code "SCR" :subunit-to-unit 100}
   {:iso-code "SDG" :subunit-to-unit 100}
   {:iso-code "SEK" :subunit-to-unit 100}
   {:iso-code "SGD" :subunit-to-unit 100}
   {:iso-code "SHP" :subunit-to-unit 100}
   {:iso-code "SKK" :subunit-to-unit 100}
   {:iso-code "SLL" :subunit-to-unit 100}
   {:iso-code "SOS" :subunit-to-unit 100}
   {:iso-code "SRD" :subunit-to-unit 100}
   {:iso-code "SSP" :subunit-to-unit 100}
   {:iso-code "STD" :subunit-to-unit 100}
   {:iso-code "SVC" :subunit-to-unit 100}
   {:iso-code "SYP" :subunit-to-unit 100}
   {:iso-code "SZL" :subunit-to-unit 100}
   {:iso-code "THB" :subunit-to-unit 100}
   {:iso-code "TJS" :subunit-to-unit 100}
   {:iso-code "TMM" :subunit-to-unit 100}
   {:iso-code "TMT" :subunit-to-unit 100}
   {:iso-code "TND" :subunit-to-unit 1000}
   {:iso-code "TOP" :subunit-to-unit 100}
   {:iso-code "TRY" :subunit-to-unit 100}
   {:iso-code "TTD" :subunit-to-unit 100}
   {:iso-code "TWD" :subunit-to-unit 100}
   {:iso-code "TZS" :subunit-to-unit 100}
   {:iso-code "UAH" :subunit-to-unit 100}
   {:iso-code "UGX" :subunit-to-unit 1}
   {:iso-code "USD" :subunit-to-unit 100 :priority true}
   {:iso-code "UYU" :subunit-to-unit 100}
   {:iso-code "UZS" :subunit-to-unit 100}
   {:iso-code "VEF" :subunit-to-unit 100}
   {:iso-code "VND" :subunit-to-unit 1}
   {:iso-code "VUV" :subunit-to-unit 1}
   {:iso-code "WST" :subunit-to-unit 100}
   {:iso-code "XAF" :subunit-to-unit 1}
   {:iso-code "XAG" :subunit-to-unit 1}
   {:iso-code "XAU" :subunit-to-unit 1}
   {:iso-code "XBA" :subunit-to-unit 1}
   {:iso-code "XBB" :subunit-to-unit 1}
   {:iso-code "XBC" :subunit-to-unit 1}
   {:iso-code "XBD" :subunit-to-unit 1}
   {:iso-code "XCD" :subunit-to-unit 100}
   {:iso-code "XDR" :subunit-to-unit 1}
   {:iso-code "XFU" :subunit-to-unit 100}
   {:iso-code "XOF" :subunit-to-unit 1}
   {:iso-code "XPD" :subunit-to-unit 1}
   {:iso-code "XPF" :subunit-to-unit 1}
   {:iso-code "XPT" :subunit-to-unit 1}
   {:iso-code "YER" :subunit-to-unit 100}
   {:iso-code "ZAR" :subunit-to-unit 100}
   {:iso-code "ZMK" :subunit-to-unit 100}
   {:iso-code "ZMW" :subunit-to-unit 100}
   {:iso-code "ZWD" :subunit-to-unit 100}
   {:iso-code "ZWL" :subunit-to-unit 100}
   {:iso-code "ZWN" :subunit-to-unit 100}
   {:iso-code "ZWR" :subunit-to-unit 100}])

(defn currency->currency-rules [currency]
  (let [currency (or currency default-currency)]
    (first (filter #(= (:iso-code %) currency)
                   rules))))
