/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow;

import cascading.CascadingException;
import cascading.flow.FlowException;
import cascading.flow.FlowSession;
import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.flow.hadoop.HadoopUtil;
import cascading.flow.stack.FlowReducerStack;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;

public class FlowReducer
extends MapReduceBase
implements Reducer {
    private FlowReducerStack flowReducerStack;
    private HadoopFlowProcess currentProcess;

    public void configure(JobConf jobConf) {
        try {
            super.configure(jobConf);
            HadoopUtil.initLog4j(jobConf);
            this.currentProcess = new HadoopFlowProcess(new FlowSession(), jobConf, false);
            this.flowReducerStack = new FlowReducerStack(this.currentProcess);
        }
        catch (Throwable throwable) {
            if (throwable instanceof CascadingException) {
                throw (CascadingException)throwable;
            }
            throw new FlowException("internal error during reducer configuration", throwable);
        }
    }

    public void reduce(Object key, Iterator values, OutputCollector output, Reporter reporter) throws IOException {
        this.currentProcess.setReporter(reporter);
        try {
            this.flowReducerStack.reduce(key, values, output);
        }
        catch (Throwable throwable) {
            if (throwable instanceof CascadingException) {
                throw (CascadingException)throwable;
            }
            throw new FlowException("internal error during reducer execution", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.flowReducerStack.close();
        }
    }
}

