/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.regex;

import cascading.flow.FlowProcess;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.operation.regex.RegexOperation;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import java.beans.ConstructorProperties;

public class RegexSplitter
extends RegexOperation
implements Function {
    @ConstructorProperties(value={"patternString"})
    public RegexSplitter(String patternString) {
        super(1, patternString);
    }

    @ConstructorProperties(value={"fieldDeclaration"})
    public RegexSplitter(Fields fieldDeclaration) {
        super(1, fieldDeclaration, "\t");
    }

    @ConstructorProperties(value={"fieldDeclaration", "patternString"})
    public RegexSplitter(Fields fieldDeclaration, String patternString) {
        super(1, fieldDeclaration, patternString);
    }

    public void operate(FlowProcess flowProcess, FunctionCall functionCall) {
        String value = functionCall.getArguments().getString(Integer.valueOf(0));
        if (value == null) {
            value = "";
        }
        Tuple output = new Tuple();
        int length = this.fieldDeclaration.isUnknown() ? -1 : this.fieldDeclaration.size();
        String[] split = this.getPattern().split(value, length);
        for (int i = 0; i < split.length; ++i) {
            output.add(split[i]);
        }
        functionCall.getOutputCollector().add(output);
    }
}

