/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats;

import cascading.stats.CascadingStats;
import cascading.stats.StepStats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FlowStats
extends CascadingStats {
    String flowID;
    List<StepStats> stepStatsList = new ArrayList<StepStats>();

    public FlowStats(String flowID) {
        this.flowID = flowID;
    }

    @Override
    public Object getID() {
        return this.flowID;
    }

    public void addStepStats(StepStats stepStats) {
        this.stepStatsList.add(stepStats);
    }

    public List<StepStats> getStepStats() {
        return this.stepStatsList;
    }

    public int getStepsCount() {
        return this.stepStatsList.size();
    }

    @Override
    public long getCounterValue(Enum counter) {
        long value = 0L;
        for (StepStats step : this.stepStatsList) {
            value += step.getCounterValue(counter);
        }
        return value;
    }

    @Override
    public long getCounterValue(String group, String counter) {
        long value = 0L;
        for (StepStats step : this.stepStatsList) {
            value += step.getCounterValue(group, counter);
        }
        return value;
    }

    @Override
    public void captureDetail() {
        for (StepStats stepStats : this.stepStatsList) {
            stepStats.captureDetail();
        }
    }

    @Override
    public Collection getChildren() {
        return this.getStepStats();
    }

    @Override
    protected String getStatsString() {
        return super.getStatsString() + ", stepsCount=" + this.getStepsCount();
    }

    @Override
    public String toString() {
        return "Flow{" + this.getStatsString() + '}';
    }
}

