/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop;

import cascading.tap.hadoop.FSDigestInputStream;
import cascading.tap.hadoop.StreamedFileStatus;
import cascading.tap.hadoop.StreamedFileSystem;
import cascading.util.S3Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.apache.log4j.Logger;
import org.jets3t.service.S3Service;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;

@Deprecated
public class S3HttpFileSystem
extends StreamedFileSystem {
    private static final Logger LOG = Logger.getLogger(S3HttpFileSystem.class);
    public static final String S3TP_SCHEME = "s3tp";
    private URI uri;
    private RestS3Service s3Service;
    private S3Bucket s3Bucket;

    public void initialize(URI uri, Configuration conf) throws IOException {
        LOG.warn((Object)"the S3HttpFileSystem (s3tp://) is deprecated, please use the Hadoop NativeS3NativeFileSystem (s3n://)");
        this.setConf(conf);
        String key = conf.get("fs.s3tp.awsAccessKeyId", System.getProperty("fs.s3tp.awsAccessKeyId"));
        String secret = conf.get("fs.s3tp.awsSecretAccessKey", System.getProperty("fs.s3tp.awsSecretAccessKey"));
        this.s3Service = S3Util.getS3Service(uri, key, secret);
        this.s3Bucket = S3Util.getS3Bucket(uri);
        this.uri = URI.create(uri.getScheme() + "://" + uri.getAuthority());
    }

    public URI getUri() {
        return this.uri;
    }

    @Override
    public FSDataOutputStream create(final Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        if (!overwrite && this.exists(path)) {
            throw new IOException("file already exists: " + path);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("creating file: " + path));
        }
        final ByteArrayOutputStream stream = new ByteArrayOutputStream();
        final DigestOutputStream digestStream = new DigestOutputStream(stream, this.getMD5Digest());
        return new FSDataOutputStream(digestStream, null){

            public void close() throws IOException {
                super.close();
                S3Object object = S3Util.getObject((S3Service)S3HttpFileSystem.this.s3Service, S3HttpFileSystem.this.s3Bucket, path, S3Util.Request.CREATE_OBJECT);
                object.setContentType("text/plain");
                object.setMd5Hash(digestStream.getMessageDigest().digest());
                byte[] bytes = stream.toByteArray();
                object.setDataInputStream((InputStream)new ByteArrayInputStream(bytes));
                object.setContentLength((long)bytes.length);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("putting file: " + path));
                }
                S3Util.putObject((S3Service)S3HttpFileSystem.this.s3Service, S3HttpFileSystem.this.s3Bucket, object);
            }
        };
    }

    public FSDataInputStream open(Path path, int i) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("opening file: " + path));
        }
        S3Object object = S3Util.getObject((S3Service)this.s3Service, this.s3Bucket, path, S3Util.Request.OBJECT);
        FSDigestInputStream inputStream = new FSDigestInputStream(S3Util.getObjectInputStream(object), S3HttpFileSystem.getMD5SumFor(this.getConf(), path));
        return new FSDataInputStream((InputStream)((Object)inputStream));
    }

    @Override
    public boolean mkdirs(Path path, FsPermission fsPermission) throws IOException {
        S3Object directory;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("making dirs for: " + path));
        }
        if ((directory = S3Util.getObject((S3Service)this.s3Service, this.s3Bucket, path, S3Util.Request.DETAILS)) != null && S3Util.isDirectory(directory)) {
            return true;
        }
        directory = S3Util.getObject((S3Service)this.s3Service, this.s3Bucket, path, S3Util.Request.CREATE_DIR);
        S3Util.putObject((S3Service)this.s3Service, this.s3Bucket, directory);
        return true;
    }

    @Override
    @Deprecated
    public boolean delete(Path path) throws IOException {
        return this.delete(path, true);
    }

    @Override
    public boolean delete(Path path, boolean recursive) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("deleting file: " + path));
        }
        return S3Util.deleteObject((S3Service)this.s3Service, this.s3Bucket, path);
    }

    public boolean exists(Path path) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("testing file: " + path));
        }
        return S3Util.getObject((S3Service)this.s3Service, this.s3Bucket, path, S3Util.Request.DETAILS) != null;
    }

    @Override
    public FileStatus[] listStatus(Path path) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("listing path: " + path));
        }
        S3Object[] objects = S3Util.listObjects((S3Service)this.s3Service, this.s3Bucket, path);
        String key = S3Util.getKeyFrom(path);
        for (S3Object object : objects) {
            if (!object.getKey().equals(key) || S3Util.isDirectory(object)) continue;
            return new FileStatus[]{this.makeStatus(object)};
        }
        FileStatus[] status = new FileStatus[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            status[i] = this.makeStatus(objects[i]);
        }
        return status;
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        S3Object object = S3Util.getObject((S3Service)this.s3Service, this.s3Bucket, path, S3Util.Request.DETAILS);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("returning status for: " + path));
        }
        if (object == null) {
            throw new FileNotFoundException("file does not exist: " + path);
        }
        return this.makeStatus(object);
    }

    private StreamedFileStatus makeStatus(S3Object object) {
        return new StreamedFileStatus(object.getContentLength(), S3Util.isDirectory(object), 1, this.getDefaultBlockSize(), object.getLastModifiedDate().getTime(), new Path(this.uri.toString() + "/", object.getKey()), object.getMd5HashAsHex());
    }

    private MessageDigest getMD5Digest() throws IOException {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException exception) {
            throw new IOException("digest not found: " + exception.getMessage());
        }
    }
}

