/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple;

import cascading.tuple.Fields;
import cascading.tuple.TupleException;
import cascading.tuple.Tuples;
import cascading.util.Util;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;

public class Tuple
implements Comparable,
Iterable,
Serializable {
    private static final String printDelim = "\t";
    protected boolean isUnmodifiable = false;
    protected List<Object> elements;

    @Deprecated
    public static Tuple asUnmodifiable(Tuple tuple) {
        tuple.isUnmodifiable = true;
        return tuple;
    }

    public static Tuple size(int size) {
        return Tuple.size(size, null);
    }

    public static Tuple size(int size, Comparable value) {
        Tuple result = new Tuple();
        for (int i = 0; i < size; ++i) {
            result.add(value);
        }
        return result;
    }

    @Deprecated
    public static Tuple parse(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        string = string.replaceAll("^ *\\[*", "");
        string = string.replaceAll("\\]* *$", "");
        Scanner scanner = new Scanner(new StringReader(string));
        scanner.useDelimiter("(' *, *')|(^ *')|(' *$)");
        Tuple result = new Tuple();
        while (scanner.hasNext()) {
            if (scanner.hasNextInt()) {
                result.add(scanner.nextInt());
                continue;
            }
            if (scanner.hasNextDouble()) {
                result.add(scanner.nextDouble());
                continue;
            }
            result.add(scanner.next());
        }
        scanner.close();
        return result;
    }

    static List<Object> elements(Tuple tuple) {
        return tuple.elements;
    }

    protected Tuple(List<Object> elements) {
        this.elements = elements;
    }

    public Tuple() {
        this(new ArrayList<Object>());
    }

    @ConstructorProperties(value={"tuple"})
    public Tuple(Tuple tuple) {
        this();
        this.elements.addAll(tuple.elements);
    }

    @ConstructorProperties(value={"values"})
    public Tuple(Object ... values) {
        this();
        Collections.addAll(this.elements, values);
    }

    public boolean isUnmodifiable() {
        return this.isUnmodifiable;
    }

    public Comparable get(int pos) {
        return (Comparable)this.elements.get(pos);
    }

    public Object getObject(int pos) {
        return this.elements.get(pos);
    }

    public String getString(int pos) {
        return Tuples.toString(this.getObject(pos));
    }

    public float getFloat(int pos) {
        return Tuples.toFloat(this.getObject(pos));
    }

    public double getDouble(int pos) {
        return Tuples.toDouble(this.getObject(pos));
    }

    public int getInteger(int pos) {
        return Tuples.toInteger(this.getObject(pos));
    }

    public long getLong(int pos) {
        return Tuples.toLong(this.getObject(pos));
    }

    public short getShort(int pos) {
        return Tuples.toShort(this.getObject(pos));
    }

    public boolean getBoolean(int pos) {
        return Tuples.toBoolean(this.getObject(pos));
    }

    public Tuple get(int[] pos) {
        if (pos == null || pos.length == 0) {
            return new Tuple(this);
        }
        Tuple results = new Tuple();
        for (int i : pos) {
            results.add(this.elements.get(i));
        }
        return results;
    }

    public Tuple get(Fields declarator, Fields selector) {
        if (!declarator.isUnknown() && this.elements.size() != declarator.size()) {
            throw new TupleException("field declaration: " + declarator.print() + ", does not match tuple: " + this.print());
        }
        return this.get(declarator.getPos(selector, this.size()));
    }

    public Tuple leave(int[] pos) {
        this.verifyModifiable();
        Tuple results = this.remove(pos);
        List<Object> temp = results.elements;
        results.elements = this.elements;
        this.elements = temp;
        return results;
    }

    public void clear() {
        this.verifyModifiable();
        this.elements.clear();
    }

    public void add(Object value) {
        this.verifyModifiable();
        this.elements.add(value);
    }

    public void addAll(Object ... values) {
        this.verifyModifiable();
        if (values.length == 1 && values[0] instanceof Tuple) {
            this.addAll((Tuple)values[0]);
        } else {
            Collections.addAll(this.elements, values);
        }
    }

    public void addAll(Tuple tuple) {
        this.verifyModifiable();
        if (tuple != null) {
            this.elements.addAll(tuple.elements);
        }
    }

    public void set(int index, Object value) {
        this.verifyModifiable();
        try {
            this.elements.set(index, value);
        }
        catch (IndexOutOfBoundsException exception) {
            if (this.elements.size() != 0) {
                throw new TupleException("failed to set a value beyond the end of the tuple elements array, size: " + this.size() + " , index: " + index);
            }
            throw new TupleException("failed to set a value, tuple may not be initialized with values, is zero length");
        }
    }

    public void put(Fields declarator, Fields fields, Tuple tuple) {
        this.verifyModifiable();
        int[] pos = declarator.getPos(fields, this.size());
        for (int i = 0; i < pos.length; ++i) {
            this.elements.set(pos[i], tuple.getObject(i));
        }
    }

    public Tuple remove(int[] pos) {
        this.verifyModifiable();
        int[] offset = new int[pos.length];
        for (int i = 0; i < pos.length; ++i) {
            offset[i] = 0;
            for (int j = 0; j < i; ++j) {
                if (pos[j] >= pos[i]) continue;
                int n = i;
                offset[n] = offset[n] + 1;
            }
        }
        Tuple results = new Tuple();
        for (int i = 0; i < pos.length; ++i) {
            results.add(this.elements.remove(pos[i] - offset[i]));
        }
        return results;
    }

    public Tuple remove(Fields declarator, Fields selector) {
        return this.remove(declarator.getPos(selector, this.size()));
    }

    Tuple extract(int[] pos) {
        Tuple results = new Tuple();
        for (int i : pos) {
            results.add(this.elements.set(i, null));
        }
        return results;
    }

    void set(int[] pos, Tuple tuple) {
        this.verifyModifiable();
        if (pos.length != tuple.size()) {
            throw new TupleException("given tuple not same size as position array, tuple: " + tuple.print());
        }
        int count = 0;
        for (int i : pos) {
            this.elements.set(i, tuple.elements.get(count++));
        }
    }

    public void set(Fields declarator, Fields selector, Tuple tuple) {
        this.set(declarator.getPos(selector), tuple);
    }

    public Iterator iterator() {
        return this.elements.iterator();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public int size() {
        return this.elements.size();
    }

    private Object[] elements() {
        return this.elements.toArray();
    }

    Object[] elements(Object[] destination) {
        return this.elements.toArray(destination);
    }

    public Class[] getTypes() {
        Class[] types = new Class[this.elements.size()];
        for (int i = 0; i < this.elements.size(); ++i) {
            Object value = this.elements.get(i);
            if (value == null) continue;
            types[i] = value.getClass();
        }
        return types;
    }

    public Tuple append(Tuple ... tuples) {
        Tuple result = new Tuple(this);
        for (Tuple tuple : tuples) {
            result.addAll(tuple);
        }
        return result;
    }

    public int compareTo(Tuple other) {
        if (other == null || other.elements == null) {
            return 1;
        }
        if (other.elements.size() != this.elements.size()) {
            return this.elements.size() - other.elements.size();
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            Comparable lhs = (Comparable)this.elements.get(i);
            Comparable rhs = (Comparable)other.elements.get(i);
            if (lhs == null && rhs == null) continue;
            if (lhs == null && rhs != null) {
                return -1;
            }
            if (lhs != null && rhs == null) {
                return 1;
            }
            int c = lhs.compareTo(rhs);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    public int compareTo(Comparator[] comparators, Tuple other) {
        if (comparators == null) {
            return this.compareTo(other);
        }
        if (other == null || other.elements == null) {
            return 1;
        }
        if (other.elements.size() != this.elements.size()) {
            return this.elements.size() - other.elements.size();
        }
        if (comparators.length != this.elements.size()) {
            throw new IllegalArgumentException("comparator array not same size as tuple elements");
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            Object lhs = this.elements.get(i);
            Object rhs = other.elements.get(i);
            int c = 0;
            if (comparators[i] != null) {
                c = comparators[i].compare(lhs, rhs);
            } else if (lhs == null && rhs == null) {
                c = 0;
            } else {
                if (lhs == null && rhs != null) {
                    return -1;
                }
                if (lhs != null && rhs == null) {
                    return 1;
                }
                c = ((Comparable)lhs).compareTo((Comparable)rhs);
            }
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    public int compareTo(Object other) {
        if (other instanceof Tuple) {
            return this.compareTo((Tuple)other);
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Tuple)) {
            return false;
        }
        Tuple other = (Tuple)object;
        if (this.elements.size() != other.elements.size()) {
            return false;
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            Object lhs = this.elements.get(i);
            Object rhs = other.elements.get(i);
            if (lhs == null && rhs == null) continue;
            if (lhs == null || rhs == null) {
                return false;
            }
            if (lhs.equals(rhs)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 1;
        for (Object element : this.elements) {
            hash = 31 * hash + (element != null ? element.hashCode() : 0);
        }
        return hash;
    }

    public String toString() {
        return Util.join(this.elements, printDelim, true);
    }

    public String toString(String delim) {
        return Util.join(this.elements, delim, true);
    }

    public String toString(String delim, boolean printNull) {
        return Util.join(this.elements, delim, printNull);
    }

    public String format(String format) {
        return String.format(format, this.elements());
    }

    public String print() {
        return this.print(new StringBuffer()).toString();
    }

    protected StringBuffer print(StringBuffer buffer) {
        buffer.append("[");
        if (this.elements != null) {
            for (int i = 0; i < this.elements.size(); ++i) {
                Object element = this.elements.get(i);
                if (element instanceof Tuple) {
                    ((Tuple)element).print(buffer);
                } else if (element == null) {
                    buffer.append(element);
                } else {
                    buffer.append("'").append(element).append("'");
                }
                if (i >= this.elements.size() - 1) continue;
                buffer.append(", ");
            }
        }
        buffer.append("]");
        return buffer;
    }

    private final void verifyModifiable() {
        if (this.isUnmodifiable) {
            throw new UnsupportedOperationException("this tuple is unmodifiable");
        }
    }
}

