/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple;

import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleException;
import cascading.tuple.Tuples;
import java.beans.ConstructorProperties;

public class TupleEntry {
    Fields fields;
    private boolean isUnmodifiable = false;
    Tuple tuple;

    public static Tuple select(Fields selector, TupleEntry ... entries) {
        Tuple result = null;
        if (selector.isAll()) {
            for (TupleEntry entry : entries) {
                result = result == null ? entry.getTuple() : result.append(entry.getTuple());
            }
            return result;
        }
        int size = 0;
        for (TupleEntry entry : entries) {
            size += entry.size();
        }
        result = Tuple.size(selector.size());
        int offset = 0;
        for (TupleEntry entry : entries) {
            for (int i = 0; i < selector.size(); ++i) {
                Comparable field = selector.get(i);
                int pos = 0;
                if (field instanceof String ? (pos = entry.fields.indexOfSafe(field)) == -1 : (pos = entry.fields.translatePos((Integer)field, size) - offset) >= entry.size() || pos < 0) continue;
                result.set(i, entry.getObject(Integer.valueOf(pos)));
            }
            offset += entry.size();
        }
        return result;
    }

    public TupleEntry() {
        this.fields = new Fields(new Comparable[0]);
    }

    @ConstructorProperties(value={"isUnmodifiable"})
    public TupleEntry(boolean isUnmodifiable) {
        this.fields = new Fields(new Comparable[0]);
        this.isUnmodifiable = isUnmodifiable;
    }

    @ConstructorProperties(value={"fields"})
    public TupleEntry(Fields fields) {
        this.fields = fields;
    }

    @ConstructorProperties(value={"fields", "isUnmodifiable"})
    public TupleEntry(Fields fields, boolean isUnmodifiable) {
        this.fields = fields;
        this.isUnmodifiable = isUnmodifiable;
    }

    @ConstructorProperties(value={"fields", "tuple"})
    public TupleEntry(Fields fields, Tuple tuple) {
        this.fields = fields;
        this.tuple = tuple;
    }

    @ConstructorProperties(value={"tupleEntry"})
    public TupleEntry(TupleEntry tupleEntry) {
        this.fields = tupleEntry.fields;
        this.tuple = new Tuple(tupleEntry.getTuple());
    }

    @ConstructorProperties(value={"tuple"})
    public TupleEntry(Tuple tuple) {
        this.fields = Fields.size(tuple.size());
        this.tuple = tuple;
    }

    public boolean isUnmodifiable() {
        return this.isUnmodifiable;
    }

    public Fields getFields() {
        return this.fields;
    }

    public Tuple getTuple() {
        return this.tuple;
    }

    public Tuple getTupleCopy() {
        return new Tuple(this.tuple);
    }

    public void setTuple(Tuple tuple) {
        this.tuple = this.isUnmodifiable ? Tuples.asUnmodifiable(tuple) : tuple;
    }

    public int size() {
        return this.tuple.size();
    }

    public Comparable get(int pos) {
        return this.tuple.get(pos);
    }

    public Comparable get(Comparable fieldName) {
        return this.tuple.get(this.fields.getPos(this.asFieldName(fieldName)));
    }

    public Object getObject(Comparable fieldName) {
        return this.tuple.getObject(this.fields.getPos(this.asFieldName(fieldName)));
    }

    public void set(Comparable fieldName, Object value) {
        this.tuple.set(this.fields.getPos(fieldName), value);
    }

    public String getString(Comparable fieldName) {
        return this.tuple.getString(this.fields.getPos(this.asFieldName(fieldName)));
    }

    public float getFloat(Comparable fieldName) {
        return this.tuple.getFloat(this.fields.getPos(this.asFieldName(fieldName)));
    }

    public double getDouble(Comparable fieldName) {
        return this.tuple.getDouble(this.fields.getPos(this.asFieldName(fieldName)));
    }

    public int getInteger(Comparable fieldName) {
        return this.tuple.getInteger(this.fields.getPos(this.asFieldName(fieldName)));
    }

    public long getLong(Comparable fieldName) {
        return this.tuple.getLong(this.fields.getPos(this.asFieldName(fieldName)));
    }

    public short getShort(Comparable fieldName) {
        return this.tuple.getShort(this.fields.getPos(this.asFieldName(fieldName)));
    }

    public boolean getBoolean(Comparable fieldName) {
        return this.tuple.getBoolean(this.fields.getPos(this.asFieldName(fieldName)));
    }

    private Comparable asFieldName(Comparable fieldName) {
        if (fieldName instanceof Fields) {
            Fields fields = (Fields)fieldName;
            if (!fields.isDefined()) {
                throw new TupleException("given Fields instance must explicitly declare one field name or position: " + fields.printVerbose());
            }
            fieldName = fields.get(0);
        }
        return fieldName;
    }

    public TupleEntry selectEntry(Fields selector) {
        if (selector == null || selector.isAll()) {
            return this;
        }
        try {
            return new TupleEntry(Fields.asDeclaration(selector), this.tuple.get(this.fields, selector));
        }
        catch (Exception exception) {
            throw new TupleException("unable to select from: " + this.fields.print() + ", using selector: " + selector.print(), exception);
        }
    }

    public Tuple selectTuple(Fields selector) {
        if (selector == null || selector.isAll()) {
            return this.tuple;
        }
        try {
            return this.tuple.get(this.fields, selector);
        }
        catch (Exception exception) {
            throw new TupleException("unable to select from: " + this.fields.print() + ", using selector: " + selector.print(), exception);
        }
    }

    public int selectInteger(Fields selector) {
        if (selector.isDefined()) {
            throw new TupleException("given selector must define a field name or position to select with");
        }
        return this.tuple.getInteger(this.fields.getPos(selector.get(0)));
    }

    public void setTuple(Fields selector, Tuple tuple) {
        if (selector == null || selector.isAll()) {
            this.tuple = tuple;
            return;
        }
        try {
            this.tuple.set(this.fields, selector, tuple);
        }
        catch (Exception exception) {
            throw new TupleException("unable to select from: " + this.fields.print() + ", using selector: " + selector.print(), exception);
        }
    }

    public void set(TupleEntry tupleEntry) {
        try {
            this.tuple.set(this.fields, tupleEntry.getFields(), tupleEntry.getTuple());
        }
        catch (Exception exception) {
            throw new TupleException("unable to select from: " + this.fields.print() + ", using selector: " + tupleEntry.getFields().print(), exception);
        }
    }

    public TupleEntry appendNew(TupleEntry entry) {
        TupleEntry result = new TupleEntry();
        result.fields = this.fields.append(entry.fields.isUnknown() ? Fields.size(entry.tuple.size()) : entry.fields);
        result.tuple = this.tuple.append(entry.tuple);
        return result;
    }

    public String toString() {
        if (this.fields == null) {
            return "empty";
        }
        if (this.tuple == null) {
            return "fields: " + this.fields.print();
        }
        return "fields: " + this.fields.print() + " tuple: " + this.tuple.print();
    }
}

