/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow;

import cascading.flow.ElementGraphException;
import cascading.flow.FlowElement;
import cascading.flow.Scope;
import cascading.operation.PlannedOperation;
import cascading.operation.PlannerLevel;
import cascading.pipe.Each;
import cascading.pipe.Every;
import cascading.pipe.Group;
import cascading.pipe.Operator;
import cascading.pipe.Pipe;
import cascading.pipe.SubAssembly;
import cascading.tap.Tap;
import cascading.util.Util;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.Graphs;
import org.jgrapht.alg.KShortestPaths;
import org.jgrapht.ext.EdgeNameProvider;
import org.jgrapht.ext.IntegerNameProvider;
import org.jgrapht.ext.VertexNameProvider;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.traverse.DepthFirstIterator;
import org.jgrapht.traverse.TopologicalOrderIterator;

public class ElementGraph
extends SimpleDirectedGraph<FlowElement, Scope> {
    private static final Logger LOG = Logger.getLogger(ElementGraph.class);
    public static final Extent head = new Extent("head");
    public static final Extent tail = new Extent("tail");
    private boolean resolved;
    private Map<String, Tap> sources;
    private Map<String, Tap> sinks;
    private Map<String, Tap> traps;
    private PlannerLevel[] plannerLevels;

    ElementGraph() {
        super(Scope.class);
    }

    public ElementGraph(Pipe[] pipes, Map<String, Tap> sources, Map<String, Tap> sinks, Map<String, Tap> traps, PlannerLevel ... plannerLevels) {
        super(Scope.class);
        this.sources = sources;
        this.sinks = sinks;
        this.traps = traps;
        this.plannerLevels = plannerLevels;
        this.assembleGraph(pipes, sources, sinks);
        this.verifyGraph();
    }

    public Collection<Tap> getSources() {
        return this.sources.values();
    }

    public Collection<Tap> getSinks() {
        return this.sinks.values();
    }

    public Collection<Tap> getTraps() {
        return this.traps.values();
    }

    private void assembleGraph(Pipe[] pipes, Map<String, Tap> sources, Map<String, Tap> sinks) {
        HashMap<String, Tap> sourcesCopy = new HashMap<String, Tap>(sources);
        HashMap<String, Tap> sinksCopy = new HashMap<String, Tap>(sinks);
        for (Pipe pipe : pipes) {
            this.makeGraph(pipe, sourcesCopy, sinksCopy);
        }
        this.addExtents(sources, sinks);
    }

    private void verifyGraph() {
        FlowElement flowElement;
        if (this.vertexSet().isEmpty()) {
            return;
        }
        TopologicalOrderIterator<FlowElement, Scope> iterator = this.getTopologicalIterator();
        while (iterator.hasNext() && this.incomingEdgesOf(flowElement = (FlowElement)iterator.next()).size() == 0) {
            if (flowElement instanceof Extent) continue;
            if (flowElement instanceof Pipe) {
                throw new ElementGraphException(flowElement, "no Tap instance given to connect Pipe " + flowElement.toString());
            }
            if (flowElement instanceof Tap) {
                throw new ElementGraphException(flowElement, "no Pipe instance given to connect Tap " + flowElement.toString());
            }
            throw new ElementGraphException(flowElement, "unknown element type: " + flowElement);
        }
    }

    public ElementGraph copyElementGraph() {
        ElementGraph copy = new ElementGraph();
        Graphs.addGraph((Graph)copy, (Graph)this);
        copy.traps = new HashMap<String, Tap>(this.traps);
        return copy;
    }

    private void addExtents(Map<String, Tap> sources, Map<String, Tap> sinks) {
        Scope scope;
        this.addVertex(head);
        for (String source : sources.keySet()) {
            scope = (Scope)this.addEdge(head, sources.get(source));
            if (scope == null) continue;
            scope.setName(source);
        }
        this.addVertex(tail);
        for (String sink : sinks.keySet()) {
            scope = null;
            try {
                scope = (Scope)this.addEdge(sinks.get(sink), tail);
            }
            catch (IllegalArgumentException exception) {
                throw new ElementGraphException("missing pipe for sink tap: [" + sink + "]");
            }
            if (scope == null) {
                throw new ElementGraphException("cannot sink to the same path from multiple branches: [" + Util.join(sinks.values()) + "]");
            }
            scope.setName(sink);
        }
    }

    private void makeGraph(Pipe current, Map<String, Tap> sources, Map<String, Tap> sinks) {
        Tap source;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("adding pipe: " + current));
        }
        if (current instanceof SubAssembly) {
            for (Pipe pipe : SubAssembly.unwind(current.getPrevious())) {
                this.makeGraph(pipe, sources, sinks);
            }
            return;
        }
        if (this.containsVertex(current)) {
            return;
        }
        this.addVertex(current);
        Tap sink = sinks.remove(current.getName());
        if (sink != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("adding sink: " + sink));
            }
            this.addVertex(sink);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("adding edge: " + current + " -> " + sink));
            }
            ((Scope)this.addEdge(current, sink)).setName(current.getName());
        }
        if (SubAssembly.unwind(current.getPrevious()).length == 0 && (source = sources.remove(current.getName())) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("adding source: " + source));
            }
            this.addVertex(source);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("adding edge: " + source + " -> " + current));
            }
            ((Scope)this.addEdge(source, current)).setName(current.getName());
        }
        for (Pipe previous : SubAssembly.unwind(current.getPrevious())) {
            this.makeGraph(previous, sources, sinks);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("adding edge: " + previous + " -> " + current));
            }
            if (this.getEdge(previous, current) != null) {
                throw new ElementGraphException(previous, "cannot distinguish pipe branches, give pipe unique name: " + previous);
            }
            ((Scope)this.addEdge(previous, current)).setName(previous.getName());
        }
    }

    public TopologicalOrderIterator<FlowElement, Scope> getTopologicalIterator() {
        return new TopologicalOrderIterator((DirectedGraph)this);
    }

    public List<GraphPath<FlowElement, Scope>> getAllShortestPathsFrom(FlowElement flowElement) {
        return this.getAllShortestPathsBetween(flowElement, tail);
    }

    public List<GraphPath<FlowElement, Scope>> getAllShortestPathsTo(FlowElement flowElement) {
        return this.getAllShortestPathsBetween(head, flowElement);
    }

    public List<GraphPath<FlowElement, Scope>> getAllShortestPathsBetweenExtents() {
        List paths = new KShortestPaths((Graph)this, (Object)head, Integer.MAX_VALUE).getPaths((Object)tail);
        if (paths == null) {
            return new ArrayList<GraphPath<FlowElement, Scope>>();
        }
        return paths;
    }

    public List<GraphPath<FlowElement, Scope>> getAllShortestPathsBetween(FlowElement from, FlowElement to) {
        List paths = new KShortestPaths((Graph)this, (Object)from, Integer.MAX_VALUE).getPaths((Object)to);
        if (paths == null) {
            return new ArrayList<GraphPath<FlowElement, Scope>>();
        }
        return paths;
    }

    public DepthFirstIterator<FlowElement, Scope> getDepthFirstIterator() {
        return new DepthFirstIterator((Graph)this, (Object)head);
    }

    private SimpleDirectedGraph<FlowElement, Scope> copyWithTraps() {
        ElementGraph copy = this.copyElementGraph();
        copy.addTraps();
        return copy;
    }

    private void addTraps() {
        DepthFirstIterator<FlowElement, Scope> iterator = this.getDepthFirstIterator();
        while (iterator.hasNext()) {
            Pipe pipe;
            Tap trap;
            FlowElement element = (FlowElement)iterator.next();
            if (!(element instanceof Pipe) || (trap = this.traps.get((pipe = (Pipe)element).getName())) == null) continue;
            this.addVertex(trap);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("adding trap edge: " + pipe + " -> " + trap));
            }
            if (this.getEdge(pipe, trap) != null) continue;
            ((Scope)this.addEdge(pipe, trap)).setName(pipe.getName());
        }
    }

    public void writeDOT(String filename) {
        this.printElementGraph(filename, this.copyWithTraps());
    }

    protected void printElementGraph(String filename, final SimpleDirectedGraph<FlowElement, Scope> graph) {
        try {
            FileWriter writer = new FileWriter(filename);
            Util.writeDOT(writer, graph, new IntegerNameProvider(), (VertexNameProvider)new VertexNameProvider<FlowElement>(){

                public String getVertexName(FlowElement object) {
                    if (object instanceof Tap || object instanceof Extent) {
                        return object.toString().replaceAll("\"", "'");
                    }
                    Scope scope = (Scope)graph.outgoingEdgesOf((Object)object).iterator().next();
                    return ((Pipe)object).print(scope).replaceAll("\"", "'");
                }
            }, (EdgeNameProvider)new EdgeNameProvider<Scope>(){

                public String getEdgeName(Scope object) {
                    return object.toString().replaceAll("\"", "'").replaceAll("\n", "\\\\n");
                }
            });
            ((Writer)writer).close();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public void removeUnnecessaryPipes() {
        while (!this.internalRemoveUnnecessaryPipes()) {
        }
        int numPipes = 0;
        for (FlowElement flowElement : this.vertexSet()) {
            if (!(flowElement instanceof Pipe)) continue;
            ++numPipes;
        }
        if (numPipes == 0) {
            throw new ElementGraphException("resulting graph has no pipe elements after removing empty Pipe, assertions, and SubAssembly containers");
        }
    }

    private boolean internalRemoveUnnecessaryPipes() {
        DepthFirstIterator<FlowElement, Scope> iterator = this.getDepthFirstIterator();
        while (iterator.hasNext()) {
            FlowElement flowElement = (FlowElement)iterator.next();
            if (flowElement.getClass() != Pipe.class && !(flowElement instanceof SubAssembly) && !this.testPlannerLevel(flowElement)) continue;
            this.removeElement(flowElement);
            return false;
        }
        return true;
    }

    private void removeElement(FlowElement flowElement) {
        LOG.debug((Object)("removing: " + flowElement));
        Set incomingScopes = this.incomingEdgesOf(flowElement);
        if (incomingScopes.size() != 1) {
            throw new IllegalStateException("flow element:" + flowElement + ", has multiple input paths: " + incomingScopes.size());
        }
        Scope incoming = (Scope)incomingScopes.iterator().next();
        Set outgoingScopes = this.outgoingEdgesOf(flowElement);
        FlowElement source = (FlowElement)this.getEdgeSource(incoming);
        for (Scope outgoing : outgoingScopes) {
            FlowElement target = (FlowElement)this.getEdgeTarget(outgoing);
            this.addEdge(source, target, new Scope(outgoing));
        }
        this.removeVertex(flowElement);
    }

    private boolean testPlannerLevel(FlowElement flowElement) {
        if (!(flowElement instanceof Operator)) {
            return false;
        }
        Operator operator = (Operator)flowElement;
        if (!operator.hasPlannerLevel()) {
            return false;
        }
        for (PlannerLevel plannerLevel : this.plannerLevels) {
            if (!((PlannedOperation)operator.getOperation()).supportsPlannerLevel(plannerLevel)) continue;
            return operator.getPlannerLevel().isStricterThan(plannerLevel);
        }
        throw new IllegalStateException("encountered unsupported planner level: " + operator.getPlannerLevel().getClass().getName());
    }

    public void resolveFields() {
        if (this.resolved) {
            throw new IllegalStateException("element graph already resolved");
        }
        TopologicalOrderIterator<FlowElement, Scope> iterator = this.getTopologicalIterator();
        while (iterator.hasNext()) {
            this.resolveFields((FlowElement)iterator.next());
        }
        this.resolved = true;
    }

    private void resolveFields(FlowElement source) {
        if (source instanceof Extent) {
            return;
        }
        Set incomingScopes = this.incomingEdgesOf(source);
        Set outgoingScopes = this.outgoingEdgesOf(source);
        List flowElements = Graphs.successorListOf((DirectedGraph)this, (Object)source);
        if (flowElements.size() == 0) {
            throw new IllegalStateException("unable to find next elements in pipeline from: " + source.toString());
        }
        Scope outgoingScope = source.outgoingScopeFor(incomingScopes);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("for modifier: " + source));
            if (outgoingScope.getArgumentFields() != null) {
                LOG.debug((Object)("setting outgoing arguments: " + outgoingScope.getArgumentFields()));
            }
            if (outgoingScope.getDeclaredFields() != null) {
                LOG.debug((Object)("setting outgoing declared: " + outgoingScope.getDeclaredFields()));
            }
            if (outgoingScope.getGroupingSelectors() != null) {
                LOG.debug((Object)("setting outgoing group: " + outgoingScope.getGroupingSelectors()));
            }
            if (outgoingScope.getOutValuesSelector() != null) {
                LOG.debug((Object)("setting outgoing values: " + outgoingScope.getOutValuesSelector()));
            }
        }
        for (Scope scope : outgoingScopes) {
            scope.copyFields(outgoingScope);
        }
    }

    public List<Group> findAllMergeJoinGroups() {
        return this.findAllOfType(2, 1, Group.class, new LinkedList());
    }

    public List<Group> findAllGroups() {
        return this.findAllOfType(1, 1, Group.class, new LinkedList());
    }

    public List<Every> findAllEveries() {
        return this.findAllOfType(1, 1, Every.class, new LinkedList());
    }

    public List<Tap> findAllTaps() {
        return this.findAllOfType(1, 1, Tap.class, new LinkedList());
    }

    public List<Each> findAllEachSplits() {
        return this.findAllOfType(1, 2, Each.class, new LinkedList());
    }

    public <P> List<P> findAllOfType(int minInDegree, int minOutDegree, Class<P> type, List<P> results) {
        TopologicalOrderIterator<FlowElement, Scope> topoIterator = this.getTopologicalIterator();
        while (topoIterator.hasNext()) {
            FlowElement flowElement = (FlowElement)topoIterator.next();
            if (!type.isInstance(flowElement) || this.inDegreeOf(flowElement) < minInDegree || this.outDegreeOf(flowElement) < minOutDegree) continue;
            results.add(flowElement);
        }
        return results;
    }

    public void insertFlowElementAfter(FlowElement previousElement, FlowElement flowElement) {
        HashSet outgoing = new HashSet(this.outgoingEdgesOf(previousElement));
        this.addVertex(flowElement);
        String name = previousElement.toString();
        if (previousElement instanceof Pipe) {
            name = ((Pipe)previousElement).getName();
        }
        this.addEdge(previousElement, flowElement, new Scope(name));
        for (Scope scope : outgoing) {
            FlowElement target = (FlowElement)this.getEdgeTarget(scope);
            this.removeEdge(previousElement, target);
            this.addEdge(flowElement, target, scope);
        }
    }

    public SimpleDirectedGraph<Tap, Integer> makeTapGraph() {
        SimpleDirectedGraph tapGraph = new SimpleDirectedGraph(Integer.class);
        List<GraphPath<FlowElement, Scope>> paths = this.getAllShortestPathsBetweenExtents();
        int count = 0;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("found num paths: " + paths.size()));
        }
        for (GraphPath<FlowElement, Scope> element : paths) {
            List path = element.getEdgeList();
            Tap lastTap = null;
            for (Scope scope : path) {
                FlowElement target = (FlowElement)this.getEdgeTarget(scope);
                if (target instanceof Extent || !(target instanceof Tap)) continue;
                tapGraph.addVertex((Object)((Tap)target));
                if (lastTap != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("adding tap edge: " + lastTap + " -> " + target));
                    }
                    if (tapGraph.getEdge((Object)lastTap, (Object)((Tap)target)) == null && !tapGraph.addEdge((Object)lastTap, (Object)((Tap)target), (Object)count++)) {
                        throw new ElementGraphException("could not add graph edge: " + lastTap + " -> " + target);
                    }
                }
                lastTap = (Tap)target;
            }
        }
        return tapGraph;
    }

    public int getMaxNumPathsBetweenElementAndMergJoin(FlowElement flowElement) {
        List<Group> groups = this.findAllMergeJoinGroups();
        int maxPaths = 0;
        if (groups == null) {
            return 0;
        }
        for (Group group : groups) {
            List<GraphPath<FlowElement, Scope>> paths;
            if (flowElement == group || (paths = this.getAllShortestPathsBetween(flowElement, group)) == null) continue;
            maxPaths = Math.max(maxPaths, paths.size());
        }
        return maxPaths;
    }

    public List<FlowElement> getAllSuccessors(FlowElement element) {
        return Graphs.successorListOf((DirectedGraph)this, (Object)element);
    }

    public void replaceElementWith(FlowElement element, FlowElement replacement) {
        HashSet incoming = new HashSet(this.incomingEdgesOf(element));
        HashSet outgoing = new HashSet(this.outgoingEdgesOf(element));
        if (!this.containsVertex(replacement)) {
            this.addVertex(replacement);
        }
        for (Scope scope : incoming) {
            FlowElement source = (FlowElement)this.getEdgeSource(scope);
            this.removeEdge(source, element);
            if (source == replacement) continue;
            this.addEdge(source, replacement, scope);
        }
        for (Scope scope : outgoing) {
            FlowElement target = (FlowElement)this.getEdgeTarget(scope);
            this.removeEdge(element, target);
            if (target == replacement) continue;
            this.addEdge(replacement, target, scope);
        }
        this.removeVertex(element);
    }

    public <A extends FlowElement> Set<A> getAllChildrenOfType(FlowElement flowElement, Class<A> type) {
        HashSet allChildren = new HashSet();
        this.getAllChildrenOfType(allChildren, flowElement, type);
        return allChildren;
    }

    private <A extends FlowElement> void getAllChildrenOfType(Set<A> allSuccessors, FlowElement flowElement, Class<A> type) {
        List<FlowElement> sucessors = this.getAllSuccessors(flowElement);
        for (FlowElement sucessor : sucessors) {
            if (type.isInstance(sucessor)) {
                allSuccessors.add(sucessor);
                continue;
            }
            this.getAllChildrenOfType(allSuccessors, sucessor, type);
        }
    }

    public static class Extent
    extends Pipe {
        public Extent(String name) {
            super(name);
        }

        @Override
        public Scope outgoingScopeFor(Set<Scope> scopes) {
            return new Scope();
        }

        @Override
        public String toString() {
            return "[" + this.getName() + "]";
        }

        @Override
        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            return this.getName().equals(((Pipe)object).getName());
        }
    }
}

