/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stack;

import cascading.CascadingException;
import cascading.flow.FlowElement;
import cascading.flow.FlowException;
import cascading.flow.FlowProcess;
import cascading.flow.Scope;
import cascading.flow.stack.MapperStackElement;
import cascading.flow.stack.StackException;
import cascading.pipe.Group;
import cascading.tap.Tap;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.Tuples;
import java.io.IOException;

class GroupMapperStackElement
extends MapperStackElement {
    private final Group group;
    private final Scope outgoingScope;
    private boolean copyTuple;

    public GroupMapperStackElement(MapperStackElement previous, FlowProcess flowProcess, Scope incomingScope, Tap trap, Group group, Scope outgoingScope, boolean copyTuple) {
        super(previous, flowProcess, incomingScope, group.getName(), trap);
        this.group = group;
        this.outgoingScope = outgoingScope;
        this.copyTuple = copyTuple;
    }

    @Override
    protected FlowElement getFlowElement() {
        return this.group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collect(Tuple tuple) {
        super.collect(tuple);
        if (this.copyTuple) {
            tuple = new Tuple(tuple);
        }
        try {
            this.operateGroup(this.getTupleEntry(tuple));
        }
        finally {
            Tuples.asModifiable(tuple);
        }
    }

    private void operateGroup(TupleEntry tupleEntry) {
        try {
            this.group.collectReduceGrouping(this.incomingScope, this.outgoingScope, tupleEntry, this.lastOutput);
        }
        catch (IOException exception) {
            throw new StackException("failed writing output", exception);
        }
        catch (OutOfMemoryError error) {
            throw new StackException("out of memory, try increasing task memory allocation", error);
        }
        catch (Throwable throwable) {
            if (throwable instanceof CascadingException) {
                throw (CascadingException)throwable;
            }
            throw new FlowException("internal error", throwable);
        }
    }

    @Override
    public void prepare() {
    }

    @Override
    public void cleanup() {
    }
}

