/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stack;

import cascading.flow.FlowElement;
import cascading.flow.FlowException;
import cascading.flow.FlowProcess;
import cascading.flow.Scope;
import cascading.flow.stack.StackElement;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.util.Iterator;
import org.apache.hadoop.mapred.OutputCollector;

abstract class MapperStackElement
extends StackElement {
    final Scope incomingScope;
    private Fields incomingFields;
    private TupleEntry tupleEntry;
    OutputCollector lastOutput;

    MapperStackElement(MapperStackElement previous, FlowProcess flowProcess, Scope incomingScope, String trapName, Tap trap) {
        super(flowProcess, trapName, trap);
        this.previous = previous;
        this.incomingScope = incomingScope;
    }

    MapperStackElement(FlowProcess flowProcess, Scope incomingScope, String trapName, Tap trap) {
        super(flowProcess, trapName, trap);
        this.incomingScope = incomingScope;
    }

    public void setLastOutput(OutputCollector lastOutput) {
        this.lastOutput = lastOutput;
    }

    protected abstract FlowElement getFlowElement();

    Fields resolveIncomingFields() {
        if (this.incomingFields == null) {
            this.incomingFields = this.getFlowElement().resolveFields(this.incomingScope);
        }
        return this.incomingFields;
    }

    Scope getIncomingScope() {
        return this.incomingScope;
    }

    TupleEntry getTupleEntry(Tuple tuple) {
        if (this.tupleEntry == null) {
            this.tupleEntry = new TupleEntry(this.resolveIncomingFields(), true);
        }
        this.tupleEntry.setTuple(tuple);
        return this.tupleEntry;
    }

    public Tuple source(Object key, Object value) {
        throw new UnsupportedOperationException("collect should never be called");
    }

    @Override
    public void collect(Tuple tuple) {
        if (tuple.isEmpty()) {
            throw new FlowException("may not collect an empty tuple");
        }
    }

    @Override
    public void collect(Tuple key, Iterator tupleIterator) {
        throw new UnsupportedOperationException("collect should never be called");
    }

    public String toString() {
        return this.getFlowElement().toString();
    }
}

