/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.state;

import cascading.flow.FlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.Filter;
import cascading.operation.FilterCall;
import java.beans.ConstructorProperties;

public class Counter
extends BaseOperation
implements Filter {
    private final Enum counterEnum;
    private final String groupString;
    private final String counterString;
    private final int increment;

    @ConstructorProperties(value={"counter"})
    public Counter(Enum counter) {
        this(counter, 1);
    }

    @ConstructorProperties(value={"counter", "increment"})
    public Counter(Enum counter, int increment) {
        this.counterEnum = counter;
        this.groupString = null;
        this.counterString = null;
        this.increment = increment;
    }

    @ConstructorProperties(value={"group", "counter"})
    public Counter(String group, String counter) {
        this(group, counter, 1);
    }

    @ConstructorProperties(value={"group", "counter", "increment"})
    public Counter(String group, String counter, int increment) {
        this.counterEnum = null;
        this.groupString = group;
        this.counterString = counter;
        this.increment = increment;
    }

    public boolean isRemove(FlowProcess flowProcess, FilterCall filterCall) {
        if (this.counterEnum != null) {
            flowProcess.increment(this.counterEnum, this.increment);
        } else {
            flowProcess.increment(this.groupString, this.counterString, this.increment);
        }
        return false;
    }
}

