/*
 * Decompiled with CFR 0.152.
 */
package cascading.pipe;

import cascading.flow.FlowProcess;
import cascading.flow.Scope;
import cascading.pipe.OperatorException;
import cascading.pipe.Pipe;
import cascading.pipe.cogroup.CoGroupClosure;
import cascading.pipe.cogroup.GroupClosure;
import cascading.pipe.cogroup.InnerJoin;
import cascading.pipe.cogroup.Joiner;
import cascading.tuple.Fields;
import cascading.tuple.FieldsResolverException;
import cascading.tuple.IndexTuple;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleException;
import cascading.tuple.TuplePair;
import cascading.tuple.Tuples;
import cascading.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.log4j.Logger;

public class Group
extends Pipe {
    private static final Logger LOG = Logger.getLogger(Group.class);
    private final List<Pipe> pipes = new ArrayList<Pipe>();
    protected final Map<String, Fields> groupFieldsMap = new LinkedHashMap<String, Fields>();
    protected Map<String, Fields> sortFieldsMap = new LinkedHashMap<String, Fields>();
    private boolean reverseOrder = false;
    protected Fields declaredFields;
    protected Fields resultGroupFields;
    private int numSelfJoins = 0;
    private Joiner joiner;
    private String groupName;
    private boolean isGroupBy;
    private transient Map<String, Integer> pipePos;
    private GroupClosure closure;

    protected Group(Pipe lhs, Fields lhsGroupFields, Pipe rhs, Fields rhsGroupFields, Fields declaredFields) {
        this(lhs, lhsGroupFields, rhs, rhsGroupFields, declaredFields, null, null);
    }

    protected Group(Pipe lhs, Fields lhsGroupFields, Pipe rhs, Fields rhsGroupFields, Fields declaredFields, Fields resultGroupFields) {
        this(lhs, lhsGroupFields, rhs, rhsGroupFields, declaredFields, resultGroupFields, null);
    }

    protected Group(Pipe lhs, Fields lhsGroupFields, Pipe rhs, Fields rhsGroupFields, Fields declaredFields, Joiner joiner) {
        this(Pipe.pipes(lhs, rhs), Fields.fields(lhsGroupFields, rhsGroupFields), declaredFields, joiner);
    }

    protected Group(Pipe lhs, Fields lhsGroupFields, Pipe rhs, Fields rhsGroupFields, Fields declaredFields, Fields resultGroupFields, Joiner joiner) {
        this(Pipe.pipes(lhs, rhs), Fields.fields(lhsGroupFields, rhsGroupFields), declaredFields, resultGroupFields, joiner);
    }

    protected Group(Pipe lhs, Fields lhsGroupFields, Pipe rhs, Fields rhsGroupFields, Joiner joiner) {
        this(lhs, lhsGroupFields, rhs, rhsGroupFields, null, joiner);
    }

    protected Group(Pipe lhs, Fields lhsGroupFields, Pipe rhs, Fields rhsGroupFields) {
        this(Pipe.pipes(lhs, rhs), Fields.fields(lhsGroupFields, rhsGroupFields));
    }

    protected Group(Pipe ... pipes) {
        this(pipes, (Fields[])null);
    }

    protected Group(Pipe[] pipes, Fields[] groupFields) {
        this(null, pipes, groupFields, null, null);
    }

    protected Group(String groupName, Pipe[] pipes, Fields[] groupFields) {
        this(groupName, pipes, groupFields, null, null);
    }

    protected Group(String groupName, Pipe[] pipes, Fields[] groupFields, Fields declaredFields) {
        this(groupName, pipes, groupFields, declaredFields, null);
    }

    protected Group(String groupName, Pipe[] pipes, Fields[] groupFields, Fields declaredFields, Fields resultGroupFields) {
        this(groupName, pipes, groupFields, declaredFields, resultGroupFields, null);
    }

    protected Group(Pipe[] pipes, Fields[] groupFields, Fields declaredFields, Joiner joiner) {
        this(null, pipes, groupFields, declaredFields, null, joiner);
    }

    protected Group(Pipe[] pipes, Fields[] groupFields, Fields declaredFields, Fields resultGroupFields, Joiner joiner) {
        this(null, pipes, groupFields, declaredFields, resultGroupFields, joiner);
    }

    protected Group(String groupName, Pipe[] pipes, Fields[] groupFields, Fields declaredFields, Fields resultGroupFields, Joiner joiner) {
        this.groupName = groupName;
        int uniques = new HashSet<Pipe>(Arrays.asList(Pipe.resolvePreviousAll(pipes))).size();
        if (pipes.length > 1 && uniques == 1) {
            if (new HashSet<Fields>(Arrays.asList(groupFields)).size() != 1) {
                throw new IllegalArgumentException("all groupFields must be identical");
            }
            this.addPipe(pipes[0]);
            this.numSelfJoins = pipes.length - 1;
            this.groupFieldsMap.put(pipes[0].getName(), groupFields[0]);
            if (resultGroupFields != null && groupFields[0].size() != resultGroupFields.size()) {
                throw new IllegalArgumentException("resultGroupFields and cogroup fields must be same size");
            }
        } else {
            int last = -1;
            for (int i = 0; i < pipes.length; ++i) {
                this.addPipe(pipes[i]);
                if (groupFields == null || groupFields.length == 0) {
                    this.addGroupFields(pipes[i], Fields.FIRST);
                    continue;
                }
                if (last != -1 && last != groupFields[i].size()) {
                    throw new IllegalArgumentException("all cogroup fields must be same size");
                }
                last = groupFields[i].size();
                this.addGroupFields(pipes[i], groupFields[i]);
            }
            if (resultGroupFields != null && last != resultGroupFields.size()) {
                throw new IllegalArgumentException("resultGroupFields and cogroup fields must be same size");
            }
        }
        this.declaredFields = declaredFields;
        this.resultGroupFields = resultGroupFields;
        this.joiner = joiner;
        this.verifyCoGrouper();
    }

    protected Group(String groupName, Pipe lhs, Fields lhsGroupFields, Pipe rhs, Fields rhsGroupFields, Fields declaredFields) {
        this(lhs, lhsGroupFields, rhs, rhsGroupFields, declaredFields);
        this.groupName = groupName;
    }

    protected Group(String groupName, Pipe lhs, Fields lhsGroupFields, Pipe rhs, Fields rhsGroupFields, Fields declaredFields, Fields resultGroupFields) {
        this(lhs, lhsGroupFields, rhs, rhsGroupFields, declaredFields, resultGroupFields);
        this.groupName = groupName;
    }

    protected Group(String groupName, Pipe lhs, Fields lhsGroupFields, Pipe rhs, Fields rhsGroupFields, Fields declaredFields, Joiner joiner) {
        this(lhs, lhsGroupFields, rhs, rhsGroupFields, declaredFields, joiner);
        this.groupName = groupName;
    }

    protected Group(String groupName, Pipe lhs, Fields lhsGroupFields, Pipe rhs, Fields rhsGroupFields, Fields declaredFields, Fields resultGroupFields, Joiner joiner) {
        this(lhs, lhsGroupFields, rhs, rhsGroupFields, declaredFields, resultGroupFields, joiner);
        this.groupName = groupName;
    }

    protected Group(String groupName, Pipe lhs, Fields lhsGroupFields, Pipe rhs, Fields rhsGroupFields, Joiner joiner) {
        this(lhs, lhsGroupFields, rhs, rhsGroupFields, joiner);
        this.groupName = groupName;
    }

    protected Group(String groupName, Pipe lhs, Fields lhsGroupFields, Pipe rhs, Fields rhsGroupFields) {
        this(lhs, lhsGroupFields, rhs, rhsGroupFields);
        this.groupName = groupName;
    }

    protected Group(String groupName, Pipe ... pipes) {
        this(pipes);
        this.groupName = groupName;
    }

    protected Group(Pipe pipe, Fields groupFields, int numSelfJoins, Fields declaredFields) {
        this(pipe, groupFields, numSelfJoins);
        this.declaredFields = declaredFields;
    }

    protected Group(Pipe pipe, Fields groupFields, int numSelfJoins, Fields declaredFields, Fields resultGroupFields) {
        this(pipe, groupFields, numSelfJoins);
        this.declaredFields = declaredFields;
        this.resultGroupFields = resultGroupFields;
        if (resultGroupFields != null && groupFields.size() != resultGroupFields.size()) {
            throw new IllegalArgumentException("resultGroupFields and cogroup fields must be same size");
        }
    }

    protected Group(Pipe pipe, Fields groupFields, int numSelfJoins, Fields declaredFields, Joiner joiner) {
        this(pipe, groupFields, numSelfJoins, declaredFields);
        this.joiner = joiner;
        this.verifyCoGrouper();
    }

    protected Group(Pipe pipe, Fields groupFields, int numSelfJoins, Fields declaredFields, Fields resultGroupFields, Joiner joiner) {
        this(pipe, groupFields, numSelfJoins, declaredFields, resultGroupFields);
        this.joiner = joiner;
        this.verifyCoGrouper();
    }

    protected Group(Pipe pipe, Fields groupFields, int numSelfJoins, Joiner joiner) {
        this.addPipe(pipe);
        this.groupFieldsMap.put(pipe.getName(), groupFields);
        this.numSelfJoins = numSelfJoins;
        this.joiner = joiner;
        this.verifyCoGrouper();
    }

    protected Group(Pipe pipe, Fields groupFields, int numSelfJoins) {
        this(pipe, groupFields, numSelfJoins, (Joiner)null);
    }

    protected Group(String groupName, Pipe pipe, Fields groupFields, int numSelfJoins, Fields declaredFields) {
        this(pipe, groupFields, numSelfJoins, declaredFields);
        this.groupName = groupName;
    }

    protected Group(String groupName, Pipe pipe, Fields groupFields, int numSelfJoins, Fields declaredFields, Fields resultGroupFields) {
        this(pipe, groupFields, numSelfJoins, declaredFields, resultGroupFields);
        this.groupName = groupName;
    }

    protected Group(String groupName, Pipe pipe, Fields groupFields, int numSelfJoins, Fields declaredFields, Joiner joiner) {
        this(pipe, groupFields, numSelfJoins, declaredFields, joiner);
        this.groupName = groupName;
    }

    protected Group(String groupName, Pipe pipe, Fields groupFields, int numSelfJoins, Fields declaredFields, Fields resultGroupFields, Joiner joiner) {
        this(pipe, groupFields, numSelfJoins, declaredFields, resultGroupFields, joiner);
        this.groupName = groupName;
    }

    protected Group(String groupName, Pipe pipe, Fields groupFields, int numSelfJoins, Joiner joiner) {
        this(pipe, groupFields, numSelfJoins, joiner);
        this.groupName = groupName;
    }

    protected Group(String groupName, Pipe pipe, Fields groupFields, int numSelfJoins) {
        this(pipe, groupFields, numSelfJoins);
        this.groupName = groupName;
    }

    protected Group(Pipe pipe) {
        this(null, pipe, Fields.ALL, null, false);
    }

    protected Group(Pipe pipe, Fields groupFields) {
        this(null, pipe, groupFields, null, false);
    }

    protected Group(String groupName, Pipe pipe, Fields groupFields) {
        this(groupName, pipe, groupFields, null, false);
    }

    protected Group(Pipe pipe, Fields groupFields, Fields sortFields) {
        this(null, pipe, groupFields, sortFields, false);
    }

    protected Group(String groupName, Pipe pipe, Fields groupFields, Fields sortFields) {
        this(groupName, pipe, groupFields, sortFields, false);
    }

    protected Group(Pipe pipe, Fields groupFields, Fields sortFields, boolean reverseOrder) {
        this(null, pipe, groupFields, sortFields, reverseOrder);
    }

    protected Group(String groupName, Pipe pipe, Fields groupFields, Fields sortFields, boolean reverseOrder) {
        this(groupName, Pipe.pipes(pipe), groupFields, sortFields, reverseOrder);
    }

    protected Group(Pipe[] pipes, Fields groupFields) {
        this(null, pipes, groupFields, null, false);
    }

    protected Group(String groupName, Pipe[] pipes, Fields groupFields) {
        this(groupName, pipes, groupFields, null, false);
    }

    protected Group(Pipe[] pipes, Fields groupFields, Fields sortFields) {
        this(null, pipes, groupFields, sortFields, false);
    }

    protected Group(String groupName, Pipe[] pipe, Fields groupFields, Fields sortFields) {
        this(groupName, pipe, groupFields, sortFields, false);
    }

    protected Group(Pipe[] pipes, Fields groupFields, Fields sortFields, boolean reverseOrder) {
        this(null, pipes, groupFields, sortFields, reverseOrder);
    }

    protected Group(String groupName, Pipe[] pipes, Fields groupFields, Fields sortFields, boolean reverseOrder) {
        this.isGroupBy = true;
        this.groupName = groupName;
        for (Pipe pipe : pipes) {
            this.addPipe(pipe);
            this.groupFieldsMap.put(pipe.getName(), groupFields);
            if (sortFields == null) continue;
            this.sortFieldsMap.put(pipe.getName(), sortFields);
        }
        this.reverseOrder = reverseOrder;
        this.joiner = new InnerJoin();
    }

    private void verifyCoGrouper() {
        if (this.joiner == null) {
            this.joiner = new InnerJoin();
            return;
        }
        if (this.joiner.numJoins() == -1) {
            return;
        }
        int joins = Math.max(this.numSelfJoins, this.groupFieldsMap.size() - 1);
        if (joins != this.joiner.numJoins()) {
            throw new IllegalArgumentException("invalid cogrouper, only accepts " + this.joiner.numJoins() + " joins, there are: " + joins);
        }
    }

    public Fields getDeclaredFields() {
        return this.declaredFields;
    }

    private void addPipe(Pipe pipe) {
        if (pipe.getName() == null) {
            throw new IllegalArgumentException("each input pipe must have a name");
        }
        this.pipes.add(pipe);
    }

    private void addGroupFields(Pipe pipe, Fields fields) {
        if (this.groupFieldsMap.containsKey(pipe.getName())) {
            throw new IllegalArgumentException("each input pipe branch must be uniquely named");
        }
        this.groupFieldsMap.put(pipe.getName(), fields);
    }

    @Override
    public String getName() {
        if (this.groupName != null) {
            return this.groupName;
        }
        StringBuffer buffer = new StringBuffer();
        for (Pipe pipe : this.pipes) {
            if (buffer.length() != 0) {
                if (this.isGroupBy) {
                    buffer.append("+");
                } else {
                    buffer.append("*");
                }
            }
            buffer.append(pipe.getName());
        }
        this.groupName = buffer.toString();
        return this.groupName;
    }

    @Override
    public Pipe[] getPrevious() {
        return this.pipes.toArray(new Pipe[this.pipes.size()]);
    }

    public Map<String, Fields> getGroupingSelectors() {
        return this.groupFieldsMap;
    }

    public Map<String, Fields> getSortingSelectors() {
        return this.sortFieldsMap;
    }

    public boolean isSorted() {
        return !this.sortFieldsMap.isEmpty();
    }

    public boolean isSortReversed() {
        return this.reverseOrder;
    }

    private Map<String, Integer> getPipePos() {
        if (this.pipePos != null) {
            return this.pipePos;
        }
        this.pipePos = new HashMap<String, Integer>();
        int pos = 0;
        for (Pipe pipe : this.pipes) {
            this.pipePos.put(pipe.getName(), pos++);
        }
        return this.pipePos;
    }

    public void collectReduceGrouping(Scope incomingScope, Scope outgoingScope, TupleEntry entry, OutputCollector output) throws IOException {
        Tuple groupKey;
        Fields sortFields;
        Fields groupFields = outgoingScope.getGroupingSelectors().get(incomingScope.getName());
        Fields fields = sortFields = outgoingScope.getSortingSelectors() == null ? null : outgoingScope.getSortingSelectors().get(incomingScope.getName());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("cogroup: [" + incomingScope + "] key pos: [" + groupFields + "]"));
        }
        Tuple groupTuple = Tuples.extractTuple(entry, groupFields);
        Tuple sortTuple = sortFields == null ? null : entry.selectTuple(sortFields);
        Tuple valuesTuple = entry.getTuple();
        Tuple tuple = groupKey = sortTuple == null ? groupTuple : new TuplePair(groupTuple, sortTuple);
        if (this.isGroupBy()) {
            output.collect((Object)groupKey, (Object)valuesTuple);
            return;
        }
        Integer pos = this.getPipePos().get(incomingScope.getName());
        output.collect((Object)new IndexTuple(pos, groupKey), (Object)new IndexTuple(pos, valuesTuple));
    }

    public Tuple unwrapGrouping(Tuple tuple) {
        if (!this.isGroupBy) {
            return ((IndexTuple)tuple).getTuple();
        }
        return !this.isSorted() ? tuple : ((TuplePair)tuple).getLhs();
    }

    public Iterator<Tuple> iterateReduceValues(Tuple key, Iterator values) {
        this.closure.reset(this.joiner, key, values);
        return this.joiner.getIterator(this.closure);
    }

    public void initializeReduce(FlowProcess flowProcess, Set<Scope> incomingScopes, Scope outgoingScope) {
        if (this.isGroupBy()) {
            Scope incomingScope = incomingScopes.iterator().next();
            Fields[] groupFields = Fields.fields(outgoingScope.getGroupingSelectors().get(incomingScope.getName()));
            Fields[] valuesFields = Fields.fields(incomingScope.getOutValuesFields());
            this.closure = new GroupClosure(groupFields, valuesFields);
        } else {
            Fields[] groupFields = new Fields[this.pipes.size()];
            Fields[] valuesFields = new Fields[this.pipes.size()];
            for (Scope incomingScope : incomingScopes) {
                int pos = this.getPipePos().get(incomingScope.getName());
                groupFields[pos] = outgoingScope.getGroupingSelectors().get(incomingScope.getName());
                valuesFields[pos] = incomingScope.getOutValuesFields();
            }
            this.closure = new CoGroupClosure(flowProcess, this.numSelfJoins, groupFields, valuesFields);
        }
    }

    public boolean isGroupBy() {
        return this.isGroupBy;
    }

    boolean isSelfJoin() {
        return this.numSelfJoins != 0;
    }

    @Override
    public Scope outgoingScopeFor(Set<Scope> incomingScopes) {
        Map<String, Fields> groupingSelectors = this.resolveGroupingSelectors(incomingScopes);
        Map<String, Fields> sortingSelectors = this.resolveSortingSelectors(incomingScopes);
        Fields declared = this.resolveDeclared(incomingScopes);
        return new Scope(this.getName(), declared, this.resultGroupFields, groupingSelectors, sortingSelectors, declared, this.isGroupBy());
    }

    Map<String, Fields> resolveGroupingSelectors(Set<Scope> incomingScopes) {
        try {
            Map<String, Fields> groupingSelectors = this.getGroupingSelectors();
            Map<String, Fields> groupingFields = this.resolveSelectorsAgainstIncoming(incomingScopes, groupingSelectors, "grouping");
            Iterator<Fields> iterator = groupingFields.values().iterator();
            int size = iterator.next().size();
            while (iterator.hasNext()) {
                Fields groupingField = iterator.next();
                if (groupingField.size() != size) {
                    throw new OperatorException(this, "all grouping fields must be same size:" + this.toString());
                }
                size = groupingField.size();
            }
            return groupingFields;
        }
        catch (FieldsResolverException exception) {
            throw new OperatorException((Pipe)this, OperatorException.Kind.grouping, exception.getSourceFields(), exception.getSelectorFields(), (Throwable)exception);
        }
        catch (RuntimeException exception) {
            throw new OperatorException(this, "could not resolve grouping selector in: " + this, exception);
        }
    }

    private Map<String, Fields> resolveSelectorsAgainstIncoming(Set<Scope> incomingScopes, Map<String, Fields> selectors, String type) {
        HashMap<String, Fields> resolvedFields = new HashMap<String, Fields>();
        for (Scope incomingScope : incomingScopes) {
            Fields selector = selectors.get(incomingScope.getName());
            if (selector == null) {
                throw new OperatorException(this, "no " + type + " selector found for: " + incomingScope.getName());
            }
            Fields incomingFields = selector.isAll() ? this.resolveFields(incomingScope) : (selector.isGroup() ? incomingScope.getOutGroupingFields() : (selector.isValues() ? incomingScope.getOutValuesFields().subtract(incomingScope.getOutGroupingFields()) : this.resolveFields(incomingScope).select(selector)));
            resolvedFields.put(incomingScope.getName(), incomingFields);
        }
        return resolvedFields;
    }

    Map<String, Fields> resolveSortingSelectors(Set<Scope> incomingScopes) {
        try {
            if (this.getSortingSelectors().isEmpty()) {
                return null;
            }
            return this.resolveSelectorsAgainstIncoming(incomingScopes, this.getSortingSelectors(), "sorting");
        }
        catch (FieldsResolverException exception) {
            throw new OperatorException((Pipe)this, OperatorException.Kind.sorting, exception.getSourceFields(), exception.getSelectorFields(), (Throwable)exception);
        }
        catch (RuntimeException exception) {
            throw new OperatorException(this, "could not resolve sorting selector in: " + this, exception);
        }
    }

    @Override
    public Fields resolveFields(Scope scope) {
        if (scope.isEvery()) {
            return scope.getOutGroupingFields();
        }
        return scope.getOutValuesFields();
    }

    Fields resolveDeclared(Set<Scope> incomingScopes) {
        try {
            Fields declaredFields = this.getDeclaredFields();
            if (declaredFields != null) {
                if (incomingScopes.size() != this.pipes.size() && this.isSelfJoin()) {
                    throw new OperatorException(this, "self joins without intermediate operators are not permitted, see 'numSelfJoins' constructor or identity function");
                }
                int size = 0;
                boolean foundUnknown = false;
                ArrayList<Fields> resolvedFields = new ArrayList<Fields>();
                for (Scope incomingScope : incomingScopes) {
                    Fields fields = this.resolveFields(incomingScope);
                    foundUnknown = foundUnknown || fields.isUnknown();
                    size += fields.size();
                    resolvedFields.add(fields);
                }
                if (!foundUnknown && declaredFields.size() != size * (this.numSelfJoins + 1)) {
                    if (this.isSelfJoin()) {
                        throw new OperatorException(this, "declared grouped fields not same size as grouped values, declared: " + declaredFields.printVerbose() + " != size: " + size * (this.numSelfJoins + 1));
                    }
                    throw new OperatorException(this, "declared grouped fields not same size as grouped values, declared: " + declaredFields.printVerbose() + " resolved: " + Util.print(resolvedFields, ""));
                }
                return declaredFields;
            }
            if (this.isGroupBy()) {
                Fields commonFields = null;
                for (Scope incomingScope : incomingScopes) {
                    Fields fields = this.resolveFields(incomingScope);
                    if (commonFields == null) {
                        commonFields = fields;
                        continue;
                    }
                    if (commonFields.equals(fields)) continue;
                    throw new OperatorException(this, "merged streams must declare the same field names, expected: " + commonFields.printVerbose() + " found: " + fields.print());
                }
                return commonFields;
            }
            HashMap<String, Scope> scopesMap = new HashMap<String, Scope>();
            for (Scope incomingScope : incomingScopes) {
                scopesMap.put(incomingScope.getName(), incomingScope);
            }
            ArrayList<Fields> appendableFields = new ArrayList<Fields>();
            for (Pipe pipe : this.pipes) {
                appendableFields.add(this.resolveFields((Scope)scopesMap.get(pipe.getName())));
            }
            Fields appendedFields = new Fields(new Comparable[0]);
            try {
                for (Fields appendableField : appendableFields) {
                    appendedFields = appendedFields.append(appendableField);
                }
            }
            catch (TupleException exception) {
                String fields = "";
                for (Fields appendableField : appendableFields) {
                    fields = fields + appendableField.print();
                }
                throw new OperatorException(this, "found duplicate field names in cogrouped tuple stream: " + fields, exception);
            }
            return appendedFields;
        }
        catch (OperatorException exception) {
            throw exception;
        }
        catch (RuntimeException exception) {
            throw new OperatorException(this, "could not resolve declared fields in: " + this, exception);
        }
    }

    Fields resolveOutgoingSelector(Fields declared) {
        return declared;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Group group = (Group)object;
        if (this.groupName != null ? !this.groupName.equals(group.groupName) : group.groupName != null) {
            return false;
        }
        if (this.groupFieldsMap != null ? !((Object)this.groupFieldsMap).equals(group.groupFieldsMap) : group.groupFieldsMap != null) {
            return false;
        }
        return !(this.pipes != null ? !((Object)this.pipes).equals(group.pipes) : group.pipes != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.pipes != null ? ((Object)this.pipes).hashCode() : 0);
        result = 31 * result + (this.groupFieldsMap != null ? ((Object)this.groupFieldsMap).hashCode() : 0);
        result = 31 * result + (this.groupName != null ? this.groupName.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(super.toString());
        buffer.append("[by:");
        for (String name : this.groupFieldsMap.keySet()) {
            if (this.groupFieldsMap.size() > 1) {
                buffer.append(name).append(":");
            }
            buffer.append(this.groupFieldsMap.get(name).printVerbose());
        }
        if (this.isSelfJoin()) {
            buffer.append("[numSelfJoins:").append(this.numSelfJoins).append("]");
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    protected void printInternal(StringBuffer buffer, Scope scope) {
        super.printInternal(buffer, scope);
        buffer.append("[by:");
        Map<String, Fields> map = scope.getGroupingSelectors();
        if (map != null) {
            for (String name : map.keySet()) {
                if (map.size() > 1) {
                    buffer.append(name).append(":");
                }
                buffer.append(map.get(name).print());
            }
            if (this.isSelfJoin()) {
                buffer.append("[numSelfJoins:").append(this.numSelfJoins).append("]");
            }
        }
        buffer.append("]");
    }
}

