/*
 * Decompiled with CFR 0.152.
 */
package cascading.pipe;

import cascading.pipe.Pipe;
import cascading.util.Util;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;

public abstract class SubAssembly
extends Pipe {
    private Pipe[] tails;

    protected void setTails(Pipe ... tails) {
        this.tails = tails;
    }

    public Pipe[] getTails() {
        return this.getPrevious();
    }

    public String[] getTailNames() {
        if (this.tails == null) {
            throw new IllegalStateException("setTails must be called in the constructor");
        }
        String[] names = new String[this.tails.length];
        for (int i = 0; i < this.tails.length; ++i) {
            names[i] = this.tails[i].getName();
        }
        return names;
    }

    @Override
    public String getName() {
        return Util.join(this.getTailNames(), "+");
    }

    @Override
    public Pipe[] getPrevious() {
        if (this.tails == null) {
            throw new IllegalStateException("setTails must be called in the constructor");
        }
        return Arrays.copyOf(this.tails, this.tails.length);
    }

    public static Pipe[] unwind(Pipe ... tails) {
        HashSet<Pipe> previous = new HashSet<Pipe>();
        for (Pipe pipe : tails) {
            if (pipe instanceof SubAssembly) {
                Collections.addAll(previous, SubAssembly.unwind(pipe.getPrevious()));
                continue;
            }
            previous.add(pipe);
        }
        return previous.toArray(new Pipe[previous.size()]);
    }
}

