/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap;

import cascading.flow.Flow;
import cascading.flow.FlowElement;
import cascading.flow.FlowException;
import cascading.flow.Scope;
import cascading.scheme.Scheme;
import cascading.tap.SinkMode;
import cascading.tap.TapException;
import cascading.tuple.Fields;
import cascading.tuple.FieldsResolverException;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;

public abstract class Tap
implements FlowElement,
Serializable {
    private Scheme scheme;
    boolean writeDirect = false;
    SinkMode sinkMode = SinkMode.KEEP;

    public static Tap[] taps(Tap ... taps) {
        return taps;
    }

    protected Tap() {
    }

    protected Tap(Scheme scheme) {
        this.setScheme(scheme);
    }

    protected Tap(Scheme scheme, SinkMode sinkMode) {
        this.setScheme(scheme);
        this.sinkMode = sinkMode;
    }

    protected void setScheme(Scheme scheme) {
        this.scheme = scheme;
    }

    public Scheme getScheme() {
        return this.scheme;
    }

    public boolean isWriteDirect() {
        return this.writeDirect || this.getScheme().isWriteDirect();
    }

    public void setWriteDirect(boolean writeDirect) {
        this.writeDirect = writeDirect;
    }

    public void flowInit(Flow flow) {
    }

    public void sourceInit(JobConf conf) throws IOException {
        this.getScheme().sourceInit(this, conf);
    }

    public void sinkInit(JobConf conf) throws IOException {
        this.getScheme().sinkInit(this, conf);
    }

    public abstract Path getPath();

    public Fields getSourceFields() {
        return this.getScheme().getSourceFields();
    }

    public Fields getSinkFields() {
        return this.getScheme().getSinkFields();
    }

    public abstract TupleEntryIterator openForRead(JobConf var1) throws IOException;

    public abstract TupleEntryCollector openForWrite(JobConf var1) throws IOException;

    public Tuple source(Object key, Object value) {
        return this.getScheme().source(key, value);
    }

    public void sink(TupleEntry tupleEntry, OutputCollector outputCollector) throws IOException {
        this.getScheme().sink(tupleEntry, outputCollector);
    }

    @Override
    public Scope outgoingScopeFor(Set<Scope> incomingScopes) {
        int count = 0;
        for (Scope incomingScope : incomingScopes) {
            Fields incomingFields = this.resolveFields(incomingScope);
            if (incomingFields == null) continue;
            try {
                incomingFields.select(this.getSinkFields());
            }
            catch (FieldsResolverException exception) {
                throw new TapException(this, exception.getSourceFields(), exception.getSelectorFields(), exception);
            }
            ++count;
        }
        if (count > 1) {
            throw new FlowException("Tap may not have more than one incoming Scope");
        }
        if (count == 1) {
            return new Scope(this.getSinkFields());
        }
        return new Scope(this.getSourceFields());
    }

    @Override
    public Fields resolveIncomingOperationFields(Scope incomingScope) {
        return this.getFieldsFor(incomingScope);
    }

    @Override
    public Fields resolveFields(Scope scope) {
        return this.getFieldsFor(scope);
    }

    private Fields getFieldsFor(Scope incomingScope) {
        if (incomingScope.isEvery()) {
            return incomingScope.getOutGroupingFields();
        }
        return incomingScope.getOutValuesFields();
    }

    public Path getQualifiedPath(JobConf conf) throws IOException {
        return this.getPath();
    }

    public abstract boolean makeDirs(JobConf var1) throws IOException;

    public abstract boolean deletePath(JobConf var1) throws IOException;

    public abstract boolean pathExists(JobConf var1) throws IOException;

    public abstract long getPathModified(JobConf var1) throws IOException;

    public boolean isKeep() {
        return this.sinkMode == SinkMode.KEEP;
    }

    public boolean isReplace() {
        return this.sinkMode == SinkMode.REPLACE;
    }

    @Deprecated
    public boolean isAppend() {
        return this.sinkMode == SinkMode.APPEND;
    }

    public boolean isUpdate() {
        return this.isAppend() || this.sinkMode == SinkMode.UPDATE;
    }

    public boolean isSink() {
        return true;
    }

    public boolean isSource() {
        return true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Tap tap = (Tap)object;
        return !(this.getScheme() != null ? !this.getScheme().equals(tap.getScheme()) : tap.getScheme() != null);
    }

    public int hashCode() {
        return this.getScheme() != null ? this.getScheme().hashCode() : 0;
    }
}

