/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap;

import cascading.scheme.Scheme;
import cascading.tap.Hfs;
import cascading.tap.SinkMode;
import cascading.tap.SinkTap;
import cascading.tap.Tap;
import cascading.tap.TapException;
import cascading.tap.hadoop.TapCollector;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryCollector;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.log4j.Logger;

public class TemplateTap
extends SinkTap {
    private static final Logger LOG = Logger.getLogger(TemplateTap.class);
    private static final int OPEN_TAPS_THRESHOLD_DEFAULT = 300;
    private Tap parent;
    private String pathTemplate;
    private boolean keepParentOnDelete = false;
    private int openTapsThreshold = 300;
    private Map<String, OutputCollector> collectors = new LinkedHashMap<String, OutputCollector>(1000, 0.75f, true);

    @ConstructorProperties(value={"parent", "pathTemplate"})
    public TemplateTap(Hfs parent, String pathTemplate) {
        this(parent, pathTemplate, 300);
    }

    @ConstructorProperties(value={"parent", "pathTemplate", "openTapsThreshold"})
    public TemplateTap(Hfs parent, String pathTemplate, int openTapsThreshold) {
        super(new TemplateScheme(parent.getScheme()));
        this.parent = parent;
        this.pathTemplate = pathTemplate;
        this.openTapsThreshold = openTapsThreshold;
    }

    @ConstructorProperties(value={"parent", "pathTemplate", "sinkMode"})
    public TemplateTap(Hfs parent, String pathTemplate, SinkMode sinkMode) {
        super(new TemplateScheme(parent.getScheme()), sinkMode);
        this.parent = parent;
        this.pathTemplate = pathTemplate;
    }

    @ConstructorProperties(value={"parent", "pathTemplate", "sinkMode", "keepParentOnDelete"})
    public TemplateTap(Hfs parent, String pathTemplate, SinkMode sinkMode, boolean keepParentOnDelete) {
        this(parent, pathTemplate, sinkMode, keepParentOnDelete, 300);
    }

    @ConstructorProperties(value={"parent", "pathTemplate", "sinkMode", "keepParentOnDelete", "openTapsThreshold"})
    public TemplateTap(Hfs parent, String pathTemplate, SinkMode sinkMode, boolean keepParentOnDelete, int openTapsThreshold) {
        super(new TemplateScheme(parent.getScheme()), sinkMode);
        this.parent = parent;
        this.pathTemplate = pathTemplate;
        this.keepParentOnDelete = keepParentOnDelete;
        this.openTapsThreshold = openTapsThreshold;
    }

    @ConstructorProperties(value={"parent", "pathTemplate", "pathFields"})
    public TemplateTap(Hfs parent, String pathTemplate, Fields pathFields) {
        this(parent, pathTemplate, pathFields, 300);
    }

    @ConstructorProperties(value={"parent", "pathTemplate", "pathFields", "openTapsThreshold"})
    public TemplateTap(Hfs parent, String pathTemplate, Fields pathFields, int openTapsThreshold) {
        super(new TemplateScheme(parent.getScheme(), pathTemplate, pathFields));
        this.parent = parent;
        this.pathTemplate = pathTemplate;
        this.openTapsThreshold = openTapsThreshold;
    }

    @ConstructorProperties(value={"parent", "pathTemplate", "pathFields", "sinkMode"})
    public TemplateTap(Hfs parent, String pathTemplate, Fields pathFields, SinkMode sinkMode) {
        super(new TemplateScheme(parent.getScheme(), pathTemplate, pathFields), sinkMode);
        this.parent = parent;
        this.pathTemplate = pathTemplate;
    }

    @ConstructorProperties(value={"parent", "pathTemplate", "pathFields", "sinkMode", "keepParentOnDelete"})
    public TemplateTap(Hfs parent, String pathTemplate, Fields pathFields, SinkMode sinkMode, boolean keepParentOnDelete) {
        this(parent, pathTemplate, pathFields, sinkMode, keepParentOnDelete, 300);
    }

    @ConstructorProperties(value={"parent", "pathTemplate", "pathFields", "sinkMode", "keepParentOnDelete", "openTapsThreshold"})
    public TemplateTap(Hfs parent, String pathTemplate, Fields pathFields, SinkMode sinkMode, boolean keepParentOnDelete, int openTapsThreshold) {
        super(new TemplateScheme(parent.getScheme(), pathTemplate, pathFields), sinkMode);
        this.parent = parent;
        this.pathTemplate = pathTemplate;
        this.keepParentOnDelete = keepParentOnDelete;
        this.openTapsThreshold = openTapsThreshold;
    }

    public Tap getParent() {
        return this.parent;
    }

    public String getPathTemplate() {
        return this.pathTemplate;
    }

    @Override
    public boolean isWriteDirect() {
        return true;
    }

    @Override
    public Path getPath() {
        return this.parent.getPath();
    }

    public int getOpenTapsThreshold() {
        return this.openTapsThreshold;
    }

    @Override
    public TupleEntryCollector openForWrite(JobConf conf) throws IOException {
        return new TemplateCollector(conf);
    }

    @Override
    public boolean makeDirs(JobConf conf) throws IOException {
        return this.parent.makeDirs(conf);
    }

    @Override
    public boolean deletePath(JobConf conf) throws IOException {
        return this.keepParentOnDelete || this.parent.deletePath(conf);
    }

    @Override
    public boolean pathExists(JobConf conf) throws IOException {
        return this.parent.pathExists(conf);
    }

    @Override
    public long getPathModified(JobConf conf) throws IOException {
        return this.parent.getPathModified(conf);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        TemplateTap that = (TemplateTap)object;
        if (this.parent != null ? !this.parent.equals(that.parent) : that.parent != null) {
            return false;
        }
        return !(this.pathTemplate != null ? !this.pathTemplate.equals(that.pathTemplate) : that.pathTemplate != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
        result = 31 * result + (this.pathTemplate != null ? this.pathTemplate.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[\"" + this.parent + "\"]" + "[\"" + this.pathTemplate + "\"]";
    }

    public static class TemplateScheme
    extends Scheme {
        private final Scheme scheme;
        private final Fields pathFields;
        private final String pathTemplate;

        public TemplateScheme(Scheme scheme) {
            this.scheme = scheme;
            this.pathFields = null;
            this.pathTemplate = null;
        }

        public TemplateScheme(Scheme scheme, String pathTemplate, Fields pathFields) {
            this.scheme = scheme;
            this.pathFields = pathFields;
            this.pathTemplate = pathTemplate;
        }

        @Override
        public Fields getSinkFields() {
            return this.scheme.getSinkFields();
        }

        @Override
        public void setSinkFields(Fields sinkFields) {
            this.scheme.setSinkFields(sinkFields);
        }

        @Override
        public Fields getSourceFields() {
            return this.scheme.getSourceFields();
        }

        @Override
        public void setSourceFields(Fields sourceFields) {
            this.scheme.setSourceFields(sourceFields);
        }

        @Override
        public int getNumSinkParts() {
            return this.scheme.getNumSinkParts();
        }

        @Override
        public void setNumSinkParts(int numSinkParts) {
            this.scheme.setNumSinkParts(numSinkParts);
        }

        @Override
        public boolean isWriteDirect() {
            return this.scheme.isWriteDirect();
        }

        @Override
        public void sourceInit(Tap tap, JobConf conf) throws IOException {
            this.scheme.sourceInit(tap, conf);
        }

        @Override
        public void sinkInit(Tap tap, JobConf conf) throws IOException {
            this.scheme.sinkInit(tap, conf);
        }

        @Override
        public Tuple source(Object key, Object value) {
            return this.scheme.source(key, value);
        }

        @Override
        public void sink(TupleEntry tupleEntry, OutputCollector outputCollector) throws IOException {
            if (this.pathFields != null) {
                Tuple values = tupleEntry.selectTuple(this.pathFields);
                outputCollector = ((TemplateCollector)outputCollector).getCollector(values.format(this.pathTemplate));
            }
            this.scheme.sink(tupleEntry, outputCollector);
        }
    }

    private class TemplateCollector
    extends TupleEntryCollector
    implements OutputCollector {
        JobConf conf;

        public TemplateCollector(JobConf conf) {
            this.conf = conf;
        }

        @Override
        protected void collect(Tuple tuple) {
            throw new UnsupportedOperationException("collect should never be called on TemplateCollector");
        }

        private OutputCollector getCollector(String path) {
            OutputCollector collector = (OutputCollector)TemplateTap.this.collectors.get(path);
            if (collector != null) {
                return collector;
            }
            try {
                Hfs tap = new Hfs(TemplateTap.this.parent.getScheme(), TemplateTap.this.parent.getQualifiedPath(this.conf).toString());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("creating collector for path: " + new Path(TemplateTap.this.parent.getQualifiedPath(this.conf), path)));
                }
                collector = new TapCollector(tap, path, this.conf);
            }
            catch (IOException exception) {
                throw new TapException("unable to open template path: " + path, exception);
            }
            if (TemplateTap.this.collectors.size() > TemplateTap.this.openTapsThreshold) {
                int numToClose = Math.max(1, (int)((double)TemplateTap.this.openTapsThreshold * 0.1));
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("removing " + numToClose + " open Taps from cache of size " + TemplateTap.this.collectors.size()));
                }
                HashSet<String> removeKeys = new HashSet<String>();
                Set keys = TemplateTap.this.collectors.keySet();
                for (String key : keys) {
                    if (numToClose-- == 0) break;
                    removeKeys.add(key);
                }
                for (String removeKey : removeKeys) {
                    this.closeCollector((OutputCollector)TemplateTap.this.collectors.remove(removeKey));
                }
            }
            TemplateTap.this.collectors.put(path, collector);
            if (LOG.isInfoEnabled() && TemplateTap.this.collectors.size() % 100 == 0) {
                LOG.info((Object)("caching " + TemplateTap.this.collectors.size() + " open Taps"));
            }
            return collector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            super.close();
            try {
                for (OutputCollector collector : TemplateTap.this.collectors.values()) {
                    this.closeCollector(collector);
                }
            }
            finally {
                TemplateTap.this.collectors.clear();
            }
        }

        private void closeCollector(OutputCollector collector) {
            if (collector == null) {
                return;
            }
            try {
                ((TupleEntryCollector)collector).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void collect(Object key, Object value) throws IOException {
            String path = ((Tuple)value).format(TemplateTap.this.pathTemplate);
            this.getCollector(path).collect(key, value);
        }
    }
}

