/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop;

import cascading.flow.FlowException;
import cascading.stats.StepStats;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.log4j.Logger;

public abstract class HadoopStepStats
extends StepStats {
    private static final Logger LOG = Logger.getLogger(HadoopStepStats.class);
    int numMapTasks;
    int numReducerTasks;
    ArrayList<HadoopTaskStats> taskStats;

    public ArrayList<HadoopTaskStats> getTaskStats() {
        if (this.taskStats == null) {
            this.taskStats = new ArrayList();
        }
        return this.taskStats;
    }

    private void addTaskStats(HadoopTaskStats.TaskType taskType, TaskReport[] taskReports, boolean skipLast) {
        for (int i = 0; i < taskReports.length - (skipLast ? 1 : 0); ++i) {
            this.getTaskStats().add(new HadoopTaskStats(taskType, taskReports[i]));
        }
    }

    private void addTaskStats(TaskCompletionEvent[] events) {
        for (TaskCompletionEvent event : events) {
            if (event.getTaskStatus() == TaskCompletionEvent.Status.SUCCEEDED) continue;
            this.getTaskStats().add(new HadoopTaskStats(event));
        }
    }

    public int getNumMapTasks() {
        return this.numMapTasks;
    }

    public void setNumMapTasks(int numMapTasks) {
        this.numMapTasks = numMapTasks;
    }

    public int getNumReducerTasks() {
        return this.numReducerTasks;
    }

    public void setNumReducerTasks(int numReducerTasks) {
        this.numReducerTasks = numReducerTasks;
    }

    public String getJobID() {
        return this.getRunningJob().getJobID();
    }

    protected abstract JobClient getJobClient();

    protected abstract RunningJob getRunningJob();

    @Override
    public long getCounterValue(Enum counter) {
        try {
            return this.getRunningJob().getCounters().getCounter(counter);
        }
        catch (IOException e) {
            throw new FlowException("unable to get counter values");
        }
    }

    @Override
    public long getCounterValue(String group, String counter) {
        try {
            return this.getRunningJob().getCounters().getGroup(group).getCounter(counter);
        }
        catch (IOException e) {
            throw new FlowException("unable to get counter values");
        }
    }

    public void captureJobStats() {
        RunningJob runningJob = this.getRunningJob();
        JobConf ranJob = new JobConf(runningJob.getJobFile());
        this.setNumMapTasks(ranJob.getNumMapTasks());
        this.setNumReducerTasks(ranJob.getNumReduceTasks());
    }

    @Override
    public Collection getChildren() {
        return this.getTaskStats();
    }

    @Override
    public void captureDetail() {
        this.getTaskStats().clear();
        JobClient jobClient = this.getJobClient();
        try {
            TaskCompletionEvent[] events;
            this.addTaskStats(HadoopTaskStats.TaskType.SETUP, jobClient.getSetupTaskReports(this.getRunningJob().getID()), true);
            this.addTaskStats(HadoopTaskStats.TaskType.MAPPER, jobClient.getMapTaskReports(this.getRunningJob().getID()), false);
            this.addTaskStats(HadoopTaskStats.TaskType.REDUCER, jobClient.getReduceTaskReports(this.getRunningJob().getID()), false);
            this.addTaskStats(HadoopTaskStats.TaskType.CLEANUP, jobClient.getCleanupTaskReports(this.getRunningJob().getID()), true);
            int count = 0;
            while ((events = this.getRunningJob().getTaskCompletionEvents(count)).length != 0) {
                this.addTaskStats(events);
                count += 10;
            }
        }
        catch (IOException exception) {
            LOG.warn((Object)"unable to get task stats", (Throwable)exception);
        }
    }

    public static class HadoopTaskStats {
        public TaskType taskType;
        public String id;
        public long startTime;
        public long finishTime;
        public String status;
        public String state;
        public Map<String, Long> counters;

        public HadoopTaskStats(TaskType taskType, TaskReport taskReport) {
            this.fill(taskType, taskReport);
        }

        public HadoopTaskStats(TaskCompletionEvent taskCompletionEvent) {
            this.fill(taskCompletionEvent);
        }

        public String getId() {
            return this.id;
        }

        public void fill(TaskCompletionEvent taskCompletionEvent) {
            this.taskType = taskCompletionEvent.getTaskAttemptId().getTaskID().isMap() ? TaskType.MAPPER : TaskType.REDUCER;
            this.status = taskCompletionEvent.getTaskStatus().toString();
        }

        public void fill(TaskType taskType, TaskReport taskReport) {
            this.taskType = taskType;
            this.id = taskReport.getTaskID().toString();
            this.startTime = taskReport.getStartTime();
            this.finishTime = taskReport.getFinishTime();
            this.state = taskReport.getState();
            this.status = TaskCompletionEvent.Status.SUCCEEDED.toString();
            this.setCounters(taskReport);
        }

        private void setCounters(TaskReport taskReport) {
            this.counters = new HashMap<String, Long>();
            Counters hadoopCounters = taskReport.getCounters();
            for (Counters.Group group : hadoopCounters) {
                for (Counters.Counter counter : group) {
                    this.counters.put(group.getName() + "." + counter.getName(), counter.getCounter());
                }
            }
        }

        public long getCounterValue(Enum counter) {
            return this.getCounterValue(counter.getDeclaringClass().getName(), counter.name());
        }

        public long getCounterValue(String group, String name) {
            if (this.counters == null) {
                return 0L;
            }
            Long value = this.counters.get(group + "." + name);
            if (value == null) {
                return 0L;
            }
            return value;
        }

        public static enum TaskType {
            SETUP,
            MAPPER,
            REDUCER,
            CLEANUP;

        }
    }
}

