/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.aggregator;

import cascading.flow.FlowProcess;
import cascading.operation.Aggregator;
import cascading.operation.AggregatorCall;
import cascading.operation.BaseOperation;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public abstract class ExtentBase
extends BaseOperation<Tuple[]>
implements Aggregator<Tuple[]> {
    private final Collection<Tuple> ignoreTuples;

    @ConstructorProperties(value={"fieldDeclaration"})
    protected ExtentBase(Fields fieldDeclaration) {
        super(fieldDeclaration);
        this.ignoreTuples = null;
    }

    @ConstructorProperties(value={"numArgs", "fieldDeclaration"})
    protected ExtentBase(int numArgs, Fields fieldDeclaration) {
        super(numArgs, fieldDeclaration);
        this.ignoreTuples = null;
    }

    @ConstructorProperties(value={"fieldDeclaration", "ignoreTuples"})
    protected ExtentBase(Fields fieldDeclaration, Tuple ... ignoreTuples) {
        super(fieldDeclaration);
        this.ignoreTuples = new HashSet<Tuple>();
        Collections.addAll(this.ignoreTuples, ignoreTuples);
    }

    @Override
    public void start(FlowProcess flowProcess, AggregatorCall<Tuple[]> aggregatorCall) {
        if (aggregatorCall.getContext() == null) {
            aggregatorCall.setContext(new Tuple[1]);
        } else {
            ((Tuple[])aggregatorCall.getContext())[0] = null;
        }
    }

    @Override
    public void aggregate(FlowProcess flowProcess, AggregatorCall<Tuple[]> aggregatorCall) {
        if (this.ignoreTuples != null && this.ignoreTuples.contains(aggregatorCall.getArguments().getTuple())) {
            return;
        }
        this.performOperation((Tuple[])aggregatorCall.getContext(), aggregatorCall.getArguments());
    }

    protected abstract void performOperation(Tuple[] var1, TupleEntry var2);

    @Override
    public void complete(FlowProcess flowProcess, AggregatorCall<Tuple[]> aggregatorCall) {
        if (((Tuple[])aggregatorCall.getContext())[0] != null) {
            aggregatorCall.getOutputCollector().add(this.getResult(aggregatorCall));
        }
    }

    protected Tuple getResult(AggregatorCall<Tuple[]> aggregatorCall) {
        return ((Tuple[])aggregatorCall.getContext())[0];
    }
}

