/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.assertion;

import cascading.flow.FlowProcess;
import cascading.operation.GroupAssertion;
import cascading.operation.GroupAssertionCall;
import cascading.operation.assertion.BaseAssertion;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.beans.ConstructorProperties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public abstract class AssertGroupBase
extends BaseAssertion<Context>
implements GroupAssertion<Context> {
    private static final Logger LOG = Logger.getLogger(AssertGroupBase.class);
    protected String patternString;
    private transient Pattern pattern;
    protected long size;

    @ConstructorProperties(value={"message", "size"})
    public AssertGroupBase(String message, long size) {
        super(message);
        this.size = size;
    }

    @ConstructorProperties(value={"message", "patternString", "size"})
    protected AssertGroupBase(String message, String patternString, long size) {
        super(message);
        this.patternString = patternString;
        this.size = size;
    }

    private Pattern getPattern() {
        if (this.pattern != null) {
            return this.pattern;
        }
        this.pattern = this.patternString == null ? Pattern.compile(".*") : Pattern.compile(this.patternString);
        return this.pattern;
    }

    private boolean matchWholeTuple(Tuple input) {
        if (this.patternString == null) {
            return true;
        }
        Matcher matcher = this.getPattern().matcher(input.toString("\t"));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("pattern: " + this.getPattern() + ", matches: " + matcher.matches()));
        }
        return matcher.matches();
    }

    @Override
    public void start(FlowProcess flowProcess, GroupAssertionCall<Context> assertionCall) {
        if (assertionCall.getContext() == null) {
            assertionCall.setContext(new Context());
        }
        TupleEntry groupEntry = assertionCall.getGroup();
        Context context = (Context)assertionCall.getContext();
        if (!this.matchWholeTuple(groupEntry.getTuple())) {
            context.reset();
        } else {
            context.set(0L, groupEntry.getFields().print(), groupEntry.getTuple().print());
        }
    }

    @Override
    public void aggregate(FlowProcess flowProcess, GroupAssertionCall<Context> assertionCall) {
        Long groupSize = ((Context)assertionCall.getContext()).count;
        if (groupSize != null) {
            Context context = (Context)assertionCall.getContext();
            context.count = context.count + 1L;
        }
    }

    @Override
    public void doAssert(FlowProcess flowProcess, GroupAssertionCall<Context> assertionCall) {
        Context context = (Context)assertionCall.getContext();
        Long groupSize = context.count;
        if (groupSize == null) {
            return;
        }
        if (this.assertFails(groupSize)) {
            if (this.patternString == null) {
                this.fail(groupSize, this.size, context.fields, context.group);
            } else {
                this.fail(this.patternString, groupSize, this.size, context.fields, context.group);
            }
        }
    }

    protected abstract boolean assertFails(Long var1);

    public static class Context {
        Long count;
        String fields;
        String group;

        public Context set(long count, String fields, String group) {
            this.count = count;
            this.fields = fields;
            this.group = group;
            return this;
        }

        public Context reset() {
            this.count = null;
            this.fields = null;
            this.group = null;
            return this;
        }
    }
}

