/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.regex;

import cascading.flow.FlowProcess;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.operation.OperationCall;
import cascading.operation.regex.RegexOperation;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import java.beans.ConstructorProperties;
import java.util.regex.Matcher;

public class RegexReplace
extends RegexOperation<Matcher>
implements Function<Matcher> {
    private final String replacement;
    private boolean replaceAll = true;

    @ConstructorProperties(value={"fieldDeclaration", "patternString", "replacement", "replaceAll"})
    public RegexReplace(Fields fieldDeclaration, String patternString, String replacement, boolean replaceAll) {
        this(fieldDeclaration, patternString, replacement);
        this.replaceAll = replaceAll;
    }

    @ConstructorProperties(value={"fieldDeclaration", "patternString", "replacement"})
    public RegexReplace(Fields fieldDeclaration, String patternString, String replacement) {
        super(1, fieldDeclaration, patternString);
        this.replacement = replacement;
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<Matcher> operationCall) {
        operationCall.setContext(this.getPattern().matcher(""));
    }

    @Override
    public void operate(FlowProcess flowProcess, FunctionCall<Matcher> functionCall) {
        String value = functionCall.getArguments().getString(Integer.valueOf(0));
        if (value == null) {
            value = "";
        }
        Tuple output = new Tuple();
        Matcher matcher = ((Matcher)functionCall.getContext()).reset(value);
        if (this.replaceAll) {
            output.add(matcher.replaceAll(this.replacement));
        } else {
            output.add(matcher.replaceFirst(this.replacement));
        }
        functionCall.getOutputCollector().add(output);
    }
}

