/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.regex;

import cascading.flow.FlowProcess;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.operation.regex.RegexOperation;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import java.beans.ConstructorProperties;

public class RegexSplitGenerator
extends RegexOperation
implements Function {
    @ConstructorProperties(value={"patternString"})
    public RegexSplitGenerator(String patternString) {
        super(1, Fields.size(1), patternString);
    }

    @ConstructorProperties(value={"fieldDeclaration", "patternString"})
    public RegexSplitGenerator(Fields fieldDeclaration, String patternString) {
        super(1, fieldDeclaration, patternString);
        if (fieldDeclaration.size() != 1) {
            throw new IllegalArgumentException("fieldDeclaration may only declare one field, was " + fieldDeclaration.print());
        }
    }

    public void operate(FlowProcess flowProcess, FunctionCall functionCall) {
        String[] split;
        String value = functionCall.getArguments().getString(Integer.valueOf(0));
        if (value == null) {
            value = "";
        }
        for (String string : split = this.getPattern().split(value)) {
            functionCall.getOutputCollector().add(new Tuple(string));
        }
    }
}

