/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop;

import cascading.CascadingException;
import cascading.tuple.hadoop.TupleSerialization;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.InputBuffer;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.serializer.Deserializer;

public abstract class DeserializerComparator<T>
extends Configured
implements RawComparator<T> {
    InputBuffer buffer = new InputBuffer();
    Deserializer<T> deserializer;
    private T key1;
    private T key2;

    public void setConf(Configuration conf) {
        super.setConf(conf);
        TupleSerialization tupleSerialization = new TupleSerialization(conf);
        try {
            this.setDeserializer(tupleSerialization);
        }
        catch (IOException exception) {
            throw new CascadingException("unable to create deserializer", exception);
        }
    }

    abstract void setDeserializer(TupleSerialization var1) throws IOException;

    void setDeserializer(Deserializer<T> deserializer) throws IOException {
        this.deserializer = deserializer;
        this.deserializer.open((InputStream)this.buffer);
    }

    public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        try {
            this.buffer.reset(b1, s1, l1);
            this.key1 = this.deserializer.deserialize(this.key1);
            this.buffer.reset(b2, s2, l2);
            this.key2 = this.deserializer.deserialize(this.key2);
        }
        catch (IOException e) {
            throw new CascadingException(e);
        }
        try {
            return this.compare(this.key1, this.key2);
        }
        catch (ClassCastException exception) {
            throw new CascadingException("unable to compare Tuples, likely a CoGroup is being attempted on fields of different types or custom comparators are incorrectly set on Fields", exception);
        }
    }
}

